/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.token.CryptoCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.CalculatorState;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeCalculatorImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class CryptoCreateFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable CalculatorState calculatorState, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        CryptoCreateTransactionBody op = txnBody.cryptoCreateAccountOrThrow();
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CRYPTO_CREATE);
        feeResult.addServiceFee(1L, serviceDef.baseFee());
        if (op.hasKey()) {
            this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, SimpleFeeCalculatorImpl.countKeys((Key)op.key()));
        }
        if (!op.hookCreationDetails().isEmpty()) {
            int hooksOperations = op.hookCreationDetails().size();
            this.addExtraFee(feeResult, serviceDef, Extra.HOOKS, feeSchedule, hooksOperations);
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CRYPTO_CREATE_ACCOUNT;
    }
}

