/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.impl.RecordFinalizerBase;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.comparator.TokenComparators;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsHandler;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsHelper;
import com.hedera.node.app.service.token.records.ChildStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.service.token.records.FinalizeContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class FinalizeRecordHandler
extends RecordFinalizerBase {
    private static final Logger logger = LogManager.getLogger(FinalizeRecordHandler.class);
    public static final long LEDGER_TOTAL_TINY_BAR_FLOAT = 5000000000000000000L;
    private final StakingRewardsHandler stakingRewardsHandler;
    private final AccountsConfig accountsConfig;
    private final EntityIdFactory entityIdFactory;
    @Nullable
    private final AtomicBoolean systemEntitiesCreatedFlag;

    @Inject
    public FinalizeRecordHandler(@NonNull StakingRewardsHandler stakingRewardsHandler, @NonNull ConfigProvider configProvider, @NonNull EntityIdFactory entityIdFactory, @Nullable AtomicBoolean systemEntitiesCreatedFlag) {
        this.stakingRewardsHandler = stakingRewardsHandler;
        this.accountsConfig = (AccountsConfig)configProvider.getConfiguration().getConfigData(AccountsConfig.class);
        this.entityIdFactory = entityIdFactory;
        this.systemEntitiesCreatedFlag = systemEntitiesCreatedFlag;
    }

    @Override
    protected boolean systemEntitiesCreated() {
        return this.systemEntitiesCreatedFlag == null || this.systemEntitiesCreatedFlag.get();
    }

    public void finalizeStakingRecord(@NonNull FinalizeContext context, @NonNull HederaFunctionality functionality, @NonNull Set<AccountID> explicitRewardReceivers, @NonNull Map<AccountID, Long> prePaidRewards) {
        this.finalizeRecord(context, functionality, explicitRewardReceivers, prePaidRewards);
    }

    public void finalizeNonStakingRecord(@NonNull FinalizeContext context, @NonNull HederaFunctionality functionality) {
        this.finalizeRecord(context, functionality, null, null);
    }

    private void finalizeRecord(@NonNull FinalizeContext context, @NonNull HederaFunctionality functionality, @Nullable Set<AccountID> explicitRewardReceivers, @Nullable Map<AccountID, Long> prePaidRewards) {
        boolean hasTokenTransferLists;
        Map<AccountID, Long> hbarChanges;
        Map<AccountID, Long> rewardsPaid;
        CryptoTransferStreamBuilder recordBuilder = (CryptoTransferStreamBuilder)context.userTransactionRecordBuilder(CryptoTransferStreamBuilder.class);
        WritableAccountStore writableAccountStore = (WritableAccountStore)context.writableStore(WritableAccountStore.class);
        WritableTokenRelationStore writableTokenRelStore = (WritableTokenRelationStore)context.writableStore(WritableTokenRelationStore.class);
        WritableNftStore writableNftStore = (WritableNftStore)context.writableStore(WritableNftStore.class);
        WritableTokenStore writableTokenStore = (WritableTokenStore)context.writableStore(WritableTokenStore.class);
        if (explicitRewardReceivers != null && prePaidRewards != null && StakingRewardsHelper.requiresExternalization(rewardsPaid = this.stakingRewardsHandler.applyStakingRewards(context, explicitRewardReceivers, prePaidRewards))) {
            recordBuilder.paidStakingRewards(StakingRewardsHelper.asAccountAmounts(rewardsPaid));
        }
        long maxLegalBalance = ((LedgerConfig)context.configuration().getConfigData(LedgerConfig.class)).totalTinyBarFloat();
        try {
            hbarChanges = this.hbarChangesFrom(writableAccountStore, maxLegalBalance);
        }
        catch (HandleException e) {
            if (e.getStatus() == ResponseCodeEnum.FAIL_INVALID) {
                this.logHbarFinalizationFailInvalid(context.userTransactionRecordBuilder(StreamBuilder.class), writableAccountStore);
            }
            throw e;
        }
        RecordFinalizerBase.IsCryptoTransfer isCryptoTransfer = functionality == HederaFunctionality.CRYPTO_TRANSFER ? RecordFinalizerBase.IsCryptoTransfer.YES : RecordFinalizerBase.IsCryptoTransfer.NO;
        Map<EntityIDPair, Long> tokenRelChanges = this.tokenRelChangesFrom(writableTokenRelStore, isCryptoTransfer);
        Map<TokenID, List<NftTransfer>> nftChanges = this.nftChangesFrom(writableNftStore, writableTokenStore, tokenRelChanges);
        if (context.hasChildOrPrecedingRecords()) {
            this.deductChangesFromChildOrPrecedingRecords(context, tokenRelChanges, nftChanges, hbarChanges);
        }
        if (!hbarChanges.isEmpty()) {
            recordBuilder.transferList(TransferList.newBuilder().accountAmounts(StakingRewardsHelper.asAccountAmounts(hbarChanges)).build());
        }
        boolean bl = hasTokenTransferLists = !tokenRelChanges.isEmpty() || !nftChanges.isEmpty();
        if (hasTokenTransferLists) {
            List<TokenTransferList> tokenTransferLists = this.asTokenTransferListFrom(tokenRelChanges, isCryptoTransfer);
            List<TokenTransferList> nftTokenTransferLists = this.asTokenTransferListFromNftChanges(nftChanges);
            tokenTransferLists.addAll(nftTokenTransferLists);
            tokenTransferLists.sort(TokenComparators.TOKEN_TRANSFER_LIST_COMPARATOR);
            recordBuilder.tokenTransferLists(tokenTransferLists);
        }
    }

    private void logHbarFinalizationFailInvalid(@NonNull StreamBuilder recordBuilder, @NonNull WritableAccountStore accountStore) {
        logger.error("Non-zero net hbar change when handling body\n{}\nwith fee {}; original/modified accounts claimed to be:\n{}\n", (Object)recordBuilder.transactionBody(), (Object)recordBuilder.transactionFee(), (Object)accountStore.modifiedAccountsInState().stream().map(accountId -> String.format("\tOriginal : %s%n\tModified : %s", accountStore.getOriginalValue((AccountID)accountId), accountStore.get((AccountID)accountId))).collect(Collectors.joining("\n")));
    }

    private void deductChangesFromChildOrPrecedingRecords(@NonNull FinalizeContext context, @NonNull Map<EntityIDPair, Long> fungibleChanges, @NonNull Map<TokenID, List<NftTransfer>> nftTransfers, @NonNull Map<AccountID, Long> hbarChanges) {
        HashMap childFinalNftOwners = new HashMap();
        context.forEachChildRecord(ChildStreamBuilder.class, childRecord -> {
            List childHbarChangesFromRecord;
            List list = childHbarChangesFromRecord = childRecord.transferList() == null ? Collections.emptyList() : childRecord.transferList().accountAmounts();
            if (childHbarChangesFromRecord.size() == 1) {
                List<AccountAmount> genesisTreasuryCredit = List.of(AccountAmount.newBuilder().amount(5000000000000000000L).accountID(this.entityIdFactory.newAccountId(this.accountsConfig.treasury())).build());
                if (!childHbarChangesFromRecord.equals(genesisTreasuryCredit)) {
                    throw new IllegalStateException("Invalid hbar changes from child record");
                }
                return;
            }
            for (AccountAmount childChange : childHbarChangesFromRecord) {
                AccountID accountId = childChange.accountID();
                Long newAdjust = hbarChanges.merge(accountId, -childChange.amount(), Long::sum);
                if (newAdjust != 0L) continue;
                hbarChanges.remove(accountId);
            }
            for (TokenTransferList tokenTransfers : childRecord.tokenTransferLists()) {
                List fungibleTransfers = tokenTransfers.transfers();
                TokenID tokenId = tokenTransfers.tokenOrThrow();
                if (!fungibleTransfers.isEmpty()) {
                    for (AccountAmount unitAdjust : fungibleTransfers) {
                        long amount;
                        AccountID accountId = unitAdjust.accountIDOrThrow();
                        EntityIDPair key = new EntityIDPair(accountId, tokenId);
                        Long newAdjust = fungibleChanges.merge(key, -(amount = unitAdjust.amount()), Long::sum);
                        if (newAdjust != 0L) continue;
                        fungibleChanges.remove(key);
                    }
                    continue;
                }
                for (NftTransfer ownershipChange : tokenTransfers.nftTransfers()) {
                    AccountID newOwnerId = ownershipChange.receiverAccountIDOrElse(ZERO_ACCOUNT_ID);
                    NftID key = new NftID(tokenId, ownershipChange.serialNumber());
                    childFinalNftOwners.put(key, newOwnerId);
                }
            }
        });
        Iterator<Map.Entry<TokenID, List<NftTransfer>>> iter = nftTransfers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<TokenID, List<NftTransfer>> entry = iter.next();
            TokenID tokenId = entry.getKey();
            List<NftTransfer> nftTransfersForToken = entry.getValue();
            nftTransfersForToken.removeIf(transfer -> {
                NftID key = new NftID(tokenId, transfer.serialNumber());
                if (childFinalNftOwners.containsKey(key)) {
                    AccountID childFinalOwner = (AccountID)childFinalNftOwners.get(key);
                    AccountID ourFinalOwner = transfer.receiverAccountIDOrThrow();
                    return childFinalOwner.equals((Object)ourFinalOwner);
                }
                return false;
            });
            if (!nftTransfersForToken.isEmpty()) continue;
            iter.remove();
        }
    }
}

