/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.codec.ContractFunctionResultJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractFunctionResultProtoCodec;
import com.hedera.hapi.node.contract.schema.ContractFunctionResultSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ContractFunctionResult {
    public static final Codec<ContractFunctionResult> PROTOBUF = new ContractFunctionResultProtoCodec();
    public static final JsonCodec<ContractFunctionResult> JSON = new ContractFunctionResultJsonCodec();
    public static final ContractFunctionResult DEFAULT = ContractFunctionResult.newBuilder().build();
    @Nullable
    private final ContractID contractID;
    @NonNull
    private final Bytes contractCallResult;
    @NonNull
    private final String errorMessage;
    @NonNull
    private final Bytes bloom;
    private final long gasUsed;
    @NonNull
    private final List<ContractLoginfo> logInfo;
    @NonNull
    private final List<ContractID> createdContractIDs;
    @Nullable
    private final Bytes evmAddress;
    private final long gas;
    private final long amount;
    @NonNull
    private final Bytes functionParameters;
    @Nullable
    private final AccountID senderId;
    @NonNull
    private final List<ContractNonceInfo> contractNonces;
    @Nullable
    private final Long signerNonce;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public ContractFunctionResult(ContractID contractID, Bytes contractCallResult, String errorMessage, Bytes bloom, long gasUsed, List<ContractLoginfo> logInfo, List<ContractID> createdContractIDs, Bytes evmAddress, long gas, long amount, Bytes functionParameters, AccountID senderId, List<ContractNonceInfo> contractNonces, Long signerNonce) {
        this.$unknownFields = null;
        this.contractID = contractID;
        this.contractCallResult = contractCallResult != null ? contractCallResult : Bytes.EMPTY;
        this.errorMessage = errorMessage != null ? errorMessage : "";
        this.bloom = bloom != null ? bloom : Bytes.EMPTY;
        this.gasUsed = gasUsed;
        this.logInfo = logInfo == null ? Collections.emptyList() : logInfo;
        this.createdContractIDs = createdContractIDs == null ? Collections.emptyList() : createdContractIDs;
        this.evmAddress = evmAddress;
        this.gas = gas;
        this.amount = amount;
        this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
        this.senderId = senderId;
        this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
        this.signerNonce = signerNonce;
    }

    public ContractFunctionResult(ContractID contractID, Bytes contractCallResult, String errorMessage, Bytes bloom, long gasUsed, List<ContractLoginfo> logInfo, List<ContractID> createdContractIDs, Bytes evmAddress, long gas, long amount, Bytes functionParameters, AccountID senderId, List<ContractNonceInfo> contractNonces, Long signerNonce, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.contractID = contractID;
        this.contractCallResult = contractCallResult != null ? contractCallResult : Bytes.EMPTY;
        this.errorMessage = errorMessage != null ? errorMessage : "";
        this.bloom = bloom != null ? bloom : Bytes.EMPTY;
        this.gasUsed = gasUsed;
        this.logInfo = logInfo == null ? Collections.emptyList() : logInfo;
        this.createdContractIDs = createdContractIDs == null ? Collections.emptyList() : createdContractIDs;
        this.evmAddress = evmAddress;
        this.gas = gas;
        this.amount = amount;
        this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
        this.senderId = senderId;
        this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
        this.signerNonce = signerNonce;
    }

    public ContractID contractID() {
        return this.contractID;
    }

    public Bytes contractCallResult() {
        return this.contractCallResult;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Bytes bloom() {
        return this.bloom;
    }

    public long gasUsed() {
        return this.gasUsed;
    }

    public List<ContractLoginfo> logInfo() {
        return this.logInfo;
    }

    public List<ContractID> createdContractIDs() {
        return this.createdContractIDs;
    }

    public Bytes evmAddress() {
        return this.evmAddress;
    }

    public long gas() {
        return this.gas;
    }

    public long amount() {
        return this.amount;
    }

    public Bytes functionParameters() {
        return this.functionParameters;
    }

    public AccountID senderId() {
        return this.senderId;
    }

    public List<ContractNonceInfo> contractNonces() {
        return this.contractNonces;
    }

    public Long signerNonce() {
        return this.signerNonce;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractFunctionResultSchema.CONTRACT_ID, (Object)this.contractID, ContractID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractFunctionResultSchema.CONTRACT_CALL_RESULT, (RandomAccessData)this.contractCallResult, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)ContractFunctionResultSchema.ERROR_MESSAGE, (String)this.errorMessage, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractFunctionResultSchema.BLOOM, (RandomAccessData)this.bloom, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractFunctionResultSchema.GAS_USED, (long)this.gasUsed, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractFunctionResultSchema.LOG_INFO, this.logInfo, ContractLoginfo.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractFunctionResultSchema.CREATED_CONTRACT_IDS, this.createdContractIDs, ContractID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfOptionalBytes((FieldDefinition)ContractFunctionResultSchema.EVM_ADDRESS, (RandomAccessData)this.evmAddress);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractFunctionResultSchema.GAS, (long)this.gas, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractFunctionResultSchema.AMOUNT, (long)this.amount, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractFunctionResultSchema.FUNCTION_PARAMETERS, (RandomAccessData)this.functionParameters, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractFunctionResultSchema.SENDER_ID, (Object)this.senderId, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractFunctionResultSchema.CONTRACT_NONCES, this.contractNonces, ContractNonceInfo.PROTOBUF);
            _size += ProtoWriterTools.sizeOfOptionalLong((FieldDefinition)ContractFunctionResultSchema.SIGNER_NONCE, (Long)this.signerNonce);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<ContractNonceInfo> list;
            List<ContractID> list$createdContractIDs;
            List<ContractLoginfo> list$logInfo;
            int result = 1;
            if (this.contractID != null && !this.contractID.equals(ContractFunctionResult.DEFAULT.contractID)) {
                result = 31 * result + this.contractID.hashCode();
            }
            if (this.contractCallResult != null && !this.contractCallResult.equals((Object)ContractFunctionResult.DEFAULT.contractCallResult)) {
                result = 31 * result + this.contractCallResult.hashCode();
            }
            if (this.errorMessage != null && !this.errorMessage.equals(ContractFunctionResult.DEFAULT.errorMessage)) {
                result = 31 * result + this.errorMessage.hashCode();
            }
            if (this.bloom != null && !this.bloom.equals((Object)ContractFunctionResult.DEFAULT.bloom)) {
                result = 31 * result + this.bloom.hashCode();
            }
            if (this.gasUsed != ContractFunctionResult.DEFAULT.gasUsed) {
                result = 31 * result + Long.hashCode(this.gasUsed);
            }
            if ((list$logInfo = this.logInfo) != null) {
                for (ContractLoginfo contractLoginfo : list$logInfo) {
                    if (contractLoginfo != null) {
                        result = 31 * result + ((Object)contractLoginfo).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list$createdContractIDs = this.createdContractIDs) != null) {
                for (ContractID contractID : list$createdContractIDs) {
                    if (contractID != null) {
                        result = 31 * result + ((Object)contractID).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.evmAddress != null && !this.evmAddress.equals((Object)ContractFunctionResult.DEFAULT.evmAddress)) {
                result = 31 * result + (this.evmAddress == null ? 0 : this.evmAddress.hashCode());
            }
            if (this.gas != ContractFunctionResult.DEFAULT.gas) {
                result = 31 * result + Long.hashCode(this.gas);
            }
            if (this.amount != ContractFunctionResult.DEFAULT.amount) {
                result = 31 * result + Long.hashCode(this.amount);
            }
            if (this.functionParameters != null && !this.functionParameters.equals((Object)ContractFunctionResult.DEFAULT.functionParameters)) {
                result = 31 * result + this.functionParameters.hashCode();
            }
            if (this.senderId != null && !this.senderId.equals(ContractFunctionResult.DEFAULT.senderId)) {
                result = 31 * result + this.senderId.hashCode();
            }
            if ((list = this.contractNonces) != null) {
                for (ContractNonceInfo contractNonceInfo : list) {
                    if (contractNonceInfo != null) {
                        result = 31 * result + ((Object)contractNonceInfo).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.signerNonce != null && !this.signerNonce.equals(ContractFunctionResult.DEFAULT.signerNonce)) {
                result = 31 * result + Long.hashCode(this.signerNonce);
            }
            if (this.$unknownFields != null) {
                void var5_12;
                boolean bl = false;
                while (var5_12 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var5_12).hashCode();
                    ++var5_12;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractFunctionResult thatObj = (ContractFunctionResult)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.contractCallResult == null && thatObj.contractCallResult != null) {
            return false;
        }
        if (this.contractCallResult != null && !this.contractCallResult.equals((Object)thatObj.contractCallResult)) {
            return false;
        }
        if (this.errorMessage == null && thatObj.errorMessage != null) {
            return false;
        }
        if (this.errorMessage != null && !this.errorMessage.equals(thatObj.errorMessage)) {
            return false;
        }
        if (this.bloom == null && thatObj.bloom != null) {
            return false;
        }
        if (this.bloom != null && !this.bloom.equals((Object)thatObj.bloom)) {
            return false;
        }
        if (this.gasUsed != thatObj.gasUsed) {
            return false;
        }
        if (this.logInfo == null && thatObj.logInfo != null) {
            return false;
        }
        if (this.logInfo != null && !this.logInfo.equals(thatObj.logInfo)) {
            return false;
        }
        if (this.createdContractIDs == null && thatObj.createdContractIDs != null) {
            return false;
        }
        if (this.createdContractIDs != null && !this.createdContractIDs.equals(thatObj.createdContractIDs)) {
            return false;
        }
        if (this.evmAddress == null && thatObj.evmAddress != null) {
            return false;
        }
        if (this.evmAddress != null && !this.evmAddress.equals((Object)thatObj.evmAddress)) {
            return false;
        }
        if (this.gas != thatObj.gas) {
            return false;
        }
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.functionParameters == null && thatObj.functionParameters != null) {
            return false;
        }
        if (this.functionParameters != null && !this.functionParameters.equals((Object)thatObj.functionParameters)) {
            return false;
        }
        if (this.senderId == null && thatObj.senderId != null) {
            return false;
        }
        if (this.senderId != null && !this.senderId.equals(thatObj.senderId)) {
            return false;
        }
        if (this.contractNonces == null && thatObj.contractNonces != null) {
            return false;
        }
        if (this.contractNonces != null && !this.contractNonces.equals(thatObj.contractNonces)) {
            return false;
        }
        if (this.signerNonce == null && thatObj.signerNonce != null) {
            return false;
        }
        if (this.signerNonce != null && !this.signerNonce.equals(thatObj.signerNonce)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "ContractFunctionResult[contractID=" + String.valueOf(this.contractID) + ", contractCallResult=" + String.valueOf(this.contractCallResult) + ", errorMessage=" + this.errorMessage + ", bloom=" + String.valueOf(this.bloom) + ", gasUsed=" + this.gasUsed + ", logInfo=" + String.valueOf(this.logInfo) + ", createdContractIDs=" + String.valueOf(this.createdContractIDs) + ", evmAddress=" + String.valueOf(this.evmAddress) + ", gas=" + this.gas + ", amount=" + this.amount + ", functionParameters=" + String.valueOf(this.functionParameters) + ", senderId=" + String.valueOf(this.senderId) + ", contractNonces=" + String.valueOf(this.contractNonces) + ", signerNonce=" + this.signerNonce + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasEvmAddress() {
        return this.evmAddress != null;
    }

    public Bytes evmAddressOrElse(@NonNull Bytes defaultValue) {
        return this.hasEvmAddress() ? this.evmAddress : defaultValue;
    }

    @NonNull
    public Bytes evmAddressOrThrow() {
        return Objects.requireNonNull(this.evmAddress, "Field evmAddress is null");
    }

    public void ifEvmAddress(@NonNull Consumer<Bytes> ifPresent) {
        if (this.hasEvmAddress()) {
            ifPresent.accept(this.evmAddress);
        }
    }

    public boolean hasSenderId() {
        return this.senderId != null;
    }

    public AccountID senderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderId() ? this.senderId : defaultValue;
    }

    @NonNull
    public AccountID senderIdOrThrow() {
        return Objects.requireNonNull(this.senderId, "Field senderId is null");
    }

    public void ifSenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderId()) {
            ifPresent.accept(this.senderId);
        }
    }

    public boolean hasSignerNonce() {
        return this.signerNonce != null;
    }

    public Long signerNonceOrElse(@NonNull Long defaultValue) {
        return this.hasSignerNonce() ? this.signerNonce : defaultValue;
    }

    @NonNull
    public Long signerNonceOrThrow() {
        return Objects.requireNonNull(this.signerNonce, "Field signerNonce is null");
    }

    public void ifSignerNonce(@NonNull Consumer<Long> ifPresent) {
        if (this.hasSignerNonce()) {
            ifPresent.accept(this.signerNonce);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.contractCallResult, this.errorMessage, this.bloom, this.gasUsed, this.logInfo, this.createdContractIDs, this.evmAddress, this.gas, this.amount, this.functionParameters, this.senderId, this.contractNonces, this.signerNonce, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ContractID contractID = null;
        @NonNull
        private Bytes contractCallResult = Bytes.EMPTY;
        @NonNull
        private String errorMessage = "";
        @NonNull
        private Bytes bloom = Bytes.EMPTY;
        private long gasUsed = 0L;
        @NonNull
        private List<ContractLoginfo> logInfo = Collections.emptyList();
        @NonNull
        private List<ContractID> createdContractIDs = Collections.emptyList();
        @Nullable
        private Bytes evmAddress = null;
        private long gas = 0L;
        private long amount = 0L;
        @NonNull
        private Bytes functionParameters = Bytes.EMPTY;
        @Nullable
        private AccountID senderId = null;
        @NonNull
        private List<ContractNonceInfo> contractNonces = Collections.emptyList();
        @Nullable
        private Long signerNonce = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(ContractID contractID, Bytes contractCallResult, String errorMessage, Bytes bloom, long gasUsed, List<ContractLoginfo> logInfo, List<ContractID> createdContractIDs, Bytes evmAddress, long gas, long amount, Bytes functionParameters, AccountID senderId, List<ContractNonceInfo> contractNonces, Long signerNonce) {
            this.$unknownFields = null;
            this.contractID = contractID;
            this.contractCallResult = contractCallResult != null ? contractCallResult : Bytes.EMPTY;
            this.errorMessage = errorMessage != null ? errorMessage : "";
            this.bloom = bloom != null ? bloom : Bytes.EMPTY;
            this.gasUsed = gasUsed;
            this.logInfo = logInfo == null ? Collections.emptyList() : logInfo;
            this.createdContractIDs = createdContractIDs == null ? Collections.emptyList() : createdContractIDs;
            this.evmAddress = evmAddress;
            this.gas = gas;
            this.amount = amount;
            this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
            this.senderId = senderId;
            this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
            this.signerNonce = signerNonce;
        }

        public Builder(ContractID contractID, Bytes contractCallResult, String errorMessage, Bytes bloom, long gasUsed, List<ContractLoginfo> logInfo, List<ContractID> createdContractIDs, Bytes evmAddress, long gas, long amount, Bytes functionParameters, AccountID senderId, List<ContractNonceInfo> contractNonces, Long signerNonce, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.contractID = contractID;
            this.contractCallResult = contractCallResult != null ? contractCallResult : Bytes.EMPTY;
            this.errorMessage = errorMessage != null ? errorMessage : "";
            this.bloom = bloom != null ? bloom : Bytes.EMPTY;
            this.gasUsed = gasUsed;
            this.logInfo = logInfo == null ? Collections.emptyList() : logInfo;
            this.createdContractIDs = createdContractIDs == null ? Collections.emptyList() : createdContractIDs;
            this.evmAddress = evmAddress;
            this.gas = gas;
            this.amount = amount;
            this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
            this.senderId = senderId;
            this.contractNonces = contractNonces == null ? Collections.emptyList() : contractNonces;
            this.signerNonce = signerNonce;
        }

        public ContractFunctionResult build() {
            return new ContractFunctionResult(this.contractID, this.contractCallResult, this.errorMessage, this.bloom, this.gasUsed, this.logInfo, this.createdContractIDs, this.evmAddress, this.gas, this.amount, this.functionParameters, this.senderId, this.contractNonces, this.signerNonce);
        }

        public Builder contractID(@Nullable ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder contractCallResult(@NonNull Bytes contractCallResult) {
            this.contractCallResult = contractCallResult != null ? contractCallResult : Bytes.EMPTY;
            return this;
        }

        public Builder errorMessage(@NonNull String errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage : "";
            return this;
        }

        public Builder bloom(@NonNull Bytes bloom) {
            this.bloom = bloom != null ? bloom : Bytes.EMPTY;
            return this;
        }

        public Builder gasUsed(long gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public Builder logInfo(@NonNull List<ContractLoginfo> logInfo) {
            this.logInfo = logInfo != null ? logInfo : Collections.emptyList();
            return this;
        }

        public Builder logInfo(ContractLoginfo ... values) {
            this.logInfo = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder createdContractIDs(@NonNull List<ContractID> createdContractIDs) {
            this.createdContractIDs = createdContractIDs != null ? createdContractIDs : Collections.emptyList();
            return this;
        }

        public Builder createdContractIDs(ContractID ... values) {
            this.createdContractIDs = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder evmAddress(@Nullable Bytes evmAddress) {
            this.evmAddress = evmAddress;
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder functionParameters(@NonNull Bytes functionParameters) {
            this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
            return this;
        }

        public Builder senderId(@Nullable AccountID senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(AccountID.Builder builder) {
            this.senderId = builder.build();
            return this;
        }

        public Builder contractNonces(@NonNull List<ContractNonceInfo> contractNonces) {
            this.contractNonces = contractNonces != null ? contractNonces : Collections.emptyList();
            return this;
        }

        public Builder contractNonces(ContractNonceInfo ... values) {
            this.contractNonces = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder signerNonce(@Nullable Long signerNonce) {
            this.signerNonce = signerNonce;
            return this;
        }

        public ContractID contractID() {
            return this.contractID;
        }

        public Bytes contractCallResult() {
            return this.contractCallResult;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public Bytes bloom() {
            return this.bloom;
        }

        public long gasUsed() {
            return this.gasUsed;
        }

        public List<ContractLoginfo> logInfo() {
            return this.logInfo;
        }

        public List<ContractID> createdContractIDs() {
            return this.createdContractIDs;
        }

        public Bytes evmAddress() {
            return this.evmAddress;
        }

        public long gas() {
            return this.gas;
        }

        public long amount() {
            return this.amount;
        }

        public Bytes functionParameters() {
            return this.functionParameters;
        }

        public AccountID senderId() {
            return this.senderId;
        }

        public List<ContractNonceInfo> contractNonces() {
            return this.contractNonces;
        }

        public Long signerNonce() {
            return this.signerNonce;
        }
    }
}

