/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.block.api.BlockRequest;
import org.hiero.block.api.BlockResponse;

public interface BlockAccessServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "BlockAccessService";
    public static final String FULL_NAME = "org.hiero.block.api.BlockAccessService";

    @NonNull
    public BlockResponse getBlock(@NonNull BlockRequest var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(BlockAccessServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        BlockAccessServiceMethod m = (BlockAccessServiceMethod)method;
        try {
            switch (m.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Pipelines.unary().mapRequest(bytes -> BlockAccessServiceInterface.parseBlockRequest(bytes, options)).method(this::getBlock).mapResponse(reply -> BlockAccessServiceInterface.serializeBlockResponse(reply, options)).respondTo(replies).build();
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<BlockRequest> getBlockRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return BlockRequest.JSON;
        }
        return BlockRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<BlockResponse> getBlockResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return BlockResponse.JSON;
        }
        return BlockResponse.PROTOBUF;
    }

    @NonNull
    private static BlockRequest parseBlockRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (BlockRequest)BlockAccessServiceInterface.getBlockRequestCodec(options).parse(message.toReadableSequentialData(), false, false, 16, options.maxMessageSizeBytes());
    }

    @NonNull
    private static Bytes serializeBlockResponse(@NonNull BlockResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return BlockAccessServiceInterface.getBlockResponseCodec(options).toBytes((Object)reply);
    }

    public static enum BlockAccessServiceMethod implements ServiceInterface.Method
    {
        getBlock;

    }

    public static class BlockAccessServiceClient
    implements BlockAccessServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public BlockAccessServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public BlockResponse getBlock(@NonNull BlockRequest request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<BlockResponse> pipeline = new Pipeline<BlockResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(BlockResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getBlock is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.BlockAccessService/getBlock", BlockAccessServiceInterface.getBlockRequestCodec(this.requestOptions), BlockAccessServiceInterface.getBlockResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (BlockResponse)replyRef.get();
            }
            throw new RuntimeException("Call to getBlock completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

