/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.fluent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.fluent.SimpleAccount;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class SimpleWorld
implements WorldUpdater {
    private final SimpleWorld parent;
    private Map<Address, Optional<SimpleAccount>> accounts = new HashMap<Address, Optional<SimpleAccount>>();

    public SimpleWorld() {
        this(null);
    }

    public SimpleWorld(SimpleWorld parent) {
        this.parent = parent;
    }

    @Override
    public WorldUpdater updater() {
        return new SimpleWorld(this);
    }

    @Override
    public Account get(Address address) {
        Account account;
        Optional<Object> account2 = Optional.empty();
        if (this.accounts.containsKey(address)) {
            account2 = this.accounts.get(address);
        } else if (this.parent != null && (account = this.parent.get(address)) instanceof SimpleAccount) {
            SimpleAccount accountFromParent = (SimpleAccount)account;
            account2 = Optional.of(accountFromParent);
        }
        return account2.orElse(null);
    }

    @Override
    public MutableAccount createAccount(Address address, long nonce, Wei balance) {
        if (this.getAccount(address) != null) {
            throw new IllegalStateException("Cannot create an account when one already exists");
        }
        SimpleAccount account = new SimpleAccount(address, nonce, balance);
        this.accounts.put(address, Optional.of(account));
        return account;
    }

    @Override
    public MutableAccount getAccount(Address address) {
        MutableAccount parentAccount;
        Optional<SimpleAccount> account = this.accounts.get(address);
        if (account != null) {
            return account.orElse(null);
        }
        MutableAccount mutableAccount = parentAccount = this.parent == null ? null : this.parent.getAccount(address);
        if (parentAccount != null) {
            account = Optional.of(new SimpleAccount(parentAccount, parentAccount.getAddress(), parentAccount.getNonce(), parentAccount.getBalance(), parentAccount.getCode()));
            this.accounts.put(address, account);
            return account.get();
        }
        return null;
    }

    @Override
    public void deleteAccount(Address address) {
        this.accounts.put(address, Optional.empty());
    }

    @Override
    public Collection<? extends Account> getTouchedAccounts() {
        return this.accounts.values().stream().filter(Optional::isPresent).map(Optional::get).toList();
    }

    @Override
    public Collection<Address> getDeletedAccountAddresses() {
        return this.accounts.entrySet().stream().filter(e -> ((Optional)e.getValue()).isEmpty()).map(Map.Entry::getKey).toList();
    }

    @Override
    public void revert() {
        this.accounts = new HashMap<Address, Optional<SimpleAccount>>();
    }

    @Override
    public void commit() {
        this.accounts.forEach((address, account) -> {
            if ((account.isEmpty() || !((SimpleAccount)account.get()).commit()) && this.parent != null) {
                this.parent.accounts.put((Address)address, (Optional<SimpleAccount>)account);
            }
        });
    }

    @Override
    public Optional<WorldUpdater> parentUpdater() {
        return Optional.ofNullable(this.parent);
    }
}

