/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.common.concurrency.limits.LimitAlgorithm;
import java.util.Optional;

class LimitAlgorithmOutcomeImpl
implements LimitAlgorithm.Outcome {
    private final String originName;
    private final String algorithmType;
    private final LimitAlgorithm.Outcome.Disposition disposition;
    private final LimitAlgorithm.Outcome.Timing timing;

    private LimitAlgorithmOutcomeImpl(String originName, String algorithmType, LimitAlgorithm.Outcome.Disposition disposition, LimitAlgorithm.Outcome.Timing timing) {
        this.originName = originName;
        this.algorithmType = algorithmType;
        this.disposition = disposition;
        this.timing = timing;
    }

    @Deprecated(since="4.3.0", forRemoval=true)
    static LimitAlgorithm.Outcome create(Optional<LimitAlgorithm.Token> token) {
        return token.isPresent() ? new Accepted("unknown", "unknown", token.get(), LimitAlgorithm.Outcome.Timing.UNKNOWN) : new LimitAlgorithmOutcomeImpl("unknown", "unknown", LimitAlgorithm.Outcome.Disposition.REJECTED, LimitAlgorithm.Outcome.Timing.UNKNOWN);
    }

    static Accepted.Immediate immediateAcceptance(String originName, String algorithmType, LimitAlgorithm.Token token) {
        return new Accepted.Immediate(originName, algorithmType, token);
    }

    static LimitAlgorithm.Outcome.Deferred deferredAcceptance(String originName, String algorithmType, LimitAlgorithm.Token token, long waitStartNanos, long waitEndNanos) {
        return new Accepted.Deferred(originName, algorithmType, token, waitStartNanos, waitEndNanos);
    }

    static LimitAlgorithm.Outcome immediateRejection(String originName, String algorithmType) {
        return new Rejected.Immediate(originName, algorithmType);
    }

    static LimitAlgorithm.Outcome deferredRejection(String originName, String algorithmType, long waitStartNanos, long waitEndNanos) {
        return new Rejected.Deferred(originName, algorithmType, waitStartNanos, waitStartNanos);
    }

    @Override
    public String originName() {
        return this.originName;
    }

    @Override
    public String algorithmType() {
        return this.algorithmType;
    }

    @Override
    public LimitAlgorithm.Outcome.Disposition disposition() {
        return this.disposition;
    }

    @Override
    public LimitAlgorithm.Outcome.Timing timing() {
        return this.timing;
    }

    static class Accepted
    extends LimitAlgorithmOutcomeImpl
    implements LimitAlgorithm.Outcome.Accepted {
        private final LimitAlgorithm.Token token;

        Accepted(String originName, String algorithmType, LimitAlgorithm.Token token, LimitAlgorithm.Outcome.Timing timing) {
            super(originName, algorithmType, LimitAlgorithm.Outcome.Disposition.ACCEPTED, timing);
            this.token = token;
        }

        @Override
        public LimitAlgorithm.Token token() {
            return this.token;
        }

        static class Deferred
        extends Accepted
        implements LimitAlgorithm.Outcome.Deferred {
            private final long waitStartNanoTime;
            private final long waitEndNanoTime;

            Deferred(String originName, String algorithmType, LimitAlgorithm.Token token, long waitStartNanoTime, long waitEndNanoTime) {
                super(originName, algorithmType, token, LimitAlgorithm.Outcome.Timing.DEFERRED);
                this.waitStartNanoTime = waitStartNanoTime;
                this.waitEndNanoTime = waitEndNanoTime;
            }

            @Override
            public long waitStartNanoTime() {
                return this.waitStartNanoTime;
            }

            @Override
            public long waitEndNanoTime() {
                return this.waitEndNanoTime;
            }
        }

        static class Immediate
        extends Accepted {
            Immediate(String originName, String algorithmType, LimitAlgorithm.Token token) {
                super(originName, algorithmType, token, LimitAlgorithm.Outcome.Timing.IMMEDIATE);
            }
        }
    }

    static class Rejected
    extends LimitAlgorithmOutcomeImpl
    implements LimitAlgorithm.Outcome {
        Rejected(String originName, String algorithmType, LimitAlgorithm.Outcome.Timing timing) {
            super(originName, algorithmType, LimitAlgorithm.Outcome.Disposition.REJECTED, timing);
        }

        static class Deferred
        extends Rejected
        implements LimitAlgorithm.Outcome.Deferred {
            private final long waitStartNanoTime;
            private final long waitEndNanoTime;

            Deferred(String originName, String algorithmType, long waitStartNanoTime, long waitEndNanoTime) {
                super(originName, algorithmType, LimitAlgorithm.Outcome.Timing.DEFERRED);
                this.waitStartNanoTime = waitStartNanoTime;
                this.waitEndNanoTime = waitEndNanoTime;
            }

            @Override
            public long waitStartNanoTime() {
                return this.waitStartNanoTime;
            }

            @Override
            public long waitEndNanoTime() {
                return this.waitEndNanoTime;
            }
        }

        static class Immediate
        extends Rejected {
            Immediate(String originName, String algorithmType) {
                super(originName, algorithmType, LimitAlgorithm.Outcome.Timing.IMMEDIATE);
            }
        }
    }
}

