/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.node.app.service.contract.impl.annotations.QueryScope;
import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.scope.HandleHederaOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.token.api.ContractChangeSummary;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.hyperledger.besu.datatypes.Address;

@QueryScope
public class QueryHederaOperations
implements HederaOperations {
    private final QueryContext context;
    private final HederaConfig hederaConfig;
    private final TinybarValues tinybarValues;

    @Inject
    public QueryHederaOperations(@NonNull QueryContext context, @NonNull HederaConfig hederaConfig, @NonNull TinybarValues tinybarValues) {
        this.context = Objects.requireNonNull(context);
        this.hederaConfig = Objects.requireNonNull(hederaConfig);
        this.tinybarValues = Objects.requireNonNull(tinybarValues);
    }

    @Override
    @NonNull
    public HederaOperations begin() {
        return this;
    }

    @Override
    public void commit() {
    }

    @Override
    public void revert() {
    }

    @Override
    @NonNull
    public ContractStateStore getStore() {
        return (ContractStateStore)this.context.createStore(ContractStateStore.class);
    }

    @Override
    public long peekNextEntityNumber() {
        throw new UnsupportedOperationException("Queries cannot peek at entity numbers");
    }

    @Override
    public long useNextEntityNumber() {
        throw new UnsupportedOperationException("Queries cannot use entity numbers");
    }

    @Override
    public long contractCreationLimit() {
        throw new UnsupportedOperationException("Queries should not be considering creations");
    }

    @Override
    public long accountCreationLimit() {
        throw new UnsupportedOperationException("Queries should not be considering creations");
    }

    @Override
    @NonNull
    public Bytes entropy() {
        Bytes entropy = this.context.blockRecordInfo().prngSeed();
        return entropy == null || entropy.equals((Object)Bytes.EMPTY) ? HandleHederaOperations.ZERO_ENTROPY : entropy;
    }

    @Override
    public long lazyCreationCostInGas(@NonNull Address recipient) {
        throw new UnsupportedOperationException("Queries cannot get lazy creation cost");
    }

    @Override
    public long gasPriceInTinybars() {
        return 1L;
    }

    @Override
    public long valueInTinybars(long tinycents) {
        return this.tinybarValues.asTinybars(tinycents);
    }

    @Override
    public void collectHtsFee(@NonNull AccountID payerId, long amount) {
        throw new UnsupportedOperationException("Queries cannot collect fees");
    }

    @Override
    public void collectGasFee(@NonNull AccountID payerId, long amount, boolean withNonceIncrement) {
        throw new UnsupportedOperationException("Queries cannot collect fees");
    }

    @Override
    public void refundGasFee(@NonNull AccountID payerId, long amount) {
        throw new UnsupportedOperationException("Queries cannot refund fees");
    }

    @Override
    public void chargeStorageRent(ContractID contractID, long amount, boolean itemizeStoragePayments) {
        throw new UnsupportedOperationException("Queries cannot charge storage rent");
    }

    @Override
    public void updateStorageMetadata(ContractID contractID, @NonNull Bytes firstKey, int netChangeInSlotsUsed) {
        throw new UnsupportedOperationException("Queries cannot update storage metadata");
    }

    @Override
    public void updateLambdaStorageSlots(@NonNull AccountID accountId, int netChangeInSlotsUsed) {
        throw new UnsupportedOperationException("Queries cannot update storage slots");
    }

    @Override
    public void createContract(long num, long parentNumber, @Nullable Bytes evmAddress) {
        throw new UnsupportedOperationException("Queries cannot create a contract");
    }

    @Override
    public void createContract(long num, @NonNull ContractCreateTransactionBody op, @Nullable Bytes evmAddress) {
        throw new UnsupportedOperationException("Queries cannot create a contract");
    }

    @Override
    public void deleteAliasedContract(@NonNull Bytes evmAddress) {
        throw new UnsupportedOperationException("Queries cannot delete an contract");
    }

    @Override
    public void deleteUnaliasedContract(long number) {
        throw new UnsupportedOperationException("Queries cannot delete an contract");
    }

    @Override
    public List<Long> getModifiedAccountNumbers() {
        return Collections.emptyList();
    }

    @Override
    public ContractChangeSummary summarizeContractChanges() {
        throw new UnsupportedOperationException("Queries cannot summarize contract changes");
    }

    @Override
    public long getOriginalSlotsUsed(ContractID contractID) {
        throw new UnsupportedOperationException("Queries cannot get original slot usage");
    }

    @Override
    public void replayGasChargingIn(@NonNull FeeCharging.Context feeChargingContext) {
        throw new UnsupportedOperationException("Queries cannot get original slot usage");
    }

    @Override
    public ContractID shardAndRealmValidated(@NonNull ContractID contractId) {
        return this.configValidated(contractId, this.hederaConfig);
    }

    @Override
    public void externalizeHollowAccountMerge(@NonNull ContractID contractId, @NonNull Bytes evmAddress) {
        throw new UnsupportedOperationException("Queries cannot create accounts");
    }

    @Override
    @Nullable
    public ThrottleAdviser getThrottleAdviser() {
        return null;
    }

    @Override
    @Nullable
    public ContractMetrics contractMetrics() {
        return null;
    }
}

