/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.metrics;

import com.hedera.node.app.service.contract.impl.exec.metrics.CountAccumulateAverageMetricTriplet;
import com.swirlds.base.utility.Pair;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;

@Singleton
public class SystemContractOpsDurationMetric {
    private final Map<Pair<String, String>, CountAccumulateAverageMetricTriplet> operationDurations = new ConcurrentHashMap<Pair<String, String>, CountAccumulateAverageMetricTriplet>();
    private final Metrics metrics;

    public SystemContractOpsDurationMetric(@NonNull Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
    }

    public void recordOperationDuration(@NonNull String systemContractName, @NonNull String systemContractAddress, long durationNanos) {
        this.getOrCreateMetric(systemContractName, systemContractAddress).recordObservation(durationNanos);
    }

    private CountAccumulateAverageMetricTriplet getOrCreateMetric(@NonNull String systemContractName, @NonNull String systemContractAddress) {
        return this.operationDurations.computeIfAbsent((Pair<String, String>)Pair.of((Object)systemContractName, (Object)systemContractAddress), unused -> CountAccumulateAverageMetricTriplet.create(this.metrics, "app", String.format("%s:OpsDuration_BySystemContract_%s_%s", "SmartContractService", systemContractName, systemContractAddress), "Ops duration of system contract " + systemContractName + " with address " + systemContractAddress + " in nanoseconds"));
    }

    public CountAccumulateAverageMetricTriplet getSystemContractOpsDuration(@NonNull String systemContractName, @NonNull String systemContractAddress) {
        return this.getOrCreateMetric(systemContractName, systemContractAddress);
    }
}

