/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public record BlockNodeConfiguration(@NonNull String address, int port, int priority, long messageSizeSoftLimitBytes, long messageSizeHardLimitBytes) {
    public BlockNodeConfiguration {
        Objects.requireNonNull(address, "Address must be specified");
        if (address.isBlank()) {
            throw new IllegalArgumentException("Address must not be empty");
        }
        if (port < 1) {
            throw new IllegalArgumentException("Port must be greater than or equal to 1");
        }
        if (priority < 0) {
            throw new IllegalArgumentException("Priority must be greater than or equal to 0");
        }
        if (messageSizeSoftLimitBytes <= 0L) {
            throw new IllegalArgumentException("Message size soft limit must be greater than 0");
        }
        if (messageSizeHardLimitBytes < messageSizeSoftLimitBytes) {
            throw new IllegalArgumentException("Message size hard limit must be greater than or equal to soft limit size");
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String address;
        private int port;
        private int priority;
        private long messageSizeSoftLimitBytes;
        private long messageSizeHardLimitBytes;

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder messageSizeSoftLimitBytes(long messageSizeSoftLimitBytes) {
            this.messageSizeSoftLimitBytes = messageSizeSoftLimitBytes;
            return this;
        }

        public Builder messageSizeHardLimitBytes(long messageSizeHardLimitBytes) {
            this.messageSizeHardLimitBytes = messageSizeHardLimitBytes;
            return this;
        }

        public BlockNodeConfiguration build() {
            return new BlockNodeConfiguration(this.address, this.port, this.priority, this.messageSizeSoftLimitBytes, this.messageSizeHardLimitBytes);
        }
    }
}

