/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.cryptography.rpm;

import com.hedera.common.nativesupport.NativeBinary;
import com.hedera.common.nativesupport.OperatingSystem;
import com.hedera.common.nativesupport.SingletonLoader;
import com.hedera.common.nativesupport.api.ProcessAPI;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class ProofCompressor {
    private static final String EXECUTABLE_NAME = "compressor";
    private static final NativeBinary compressorBinary = new NativeBinary("compressor", Map.of(), Map.of(OperatingSystem.WINDOWS, "exe"));
    private static final String TSS_MARKER = "<TSS OUTPUT BEGIN>";

    public static boolean isSupported() {
        return System.getenv("SP1_GROTH16_CIRCUIT_PATH") != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compressProof(byte[] proverKey, byte[] verificationKey, byte[] uncompressedProof) {
        if (!ProofCompressor.isSupported()) {
            return null;
        }
        AtomicReference<InputStream> errStream = new AtomicReference<InputStream>();
        try (ProcessAPI processAPI = new ProcessAPI(ProofCompressor.class, compressorBinary);){
            int c;
            errStream.set(processAPI.getErrorStream());
            processAPI.sendArray(proverKey);
            processAPI.sendArray(verificationKey);
            processAPI.sendArray(uncompressedProof);
            InputStream inStream = processAPI.getInputStream();
            int markerMatch = 0;
            while ((c = inStream.read()) != -1) {
                System.err.print((char)c);
                if (c == TSS_MARKER.charAt(markerMatch)) {
                    if (++markerMatch != TSS_MARKER.length()) continue;
                    break;
                }
                markerMatch = 0;
            }
            if (c == -1) {
                ((InputStream)errStream.get()).transferTo(System.err);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = processAPI.receiveArray();
            return byArray;
        }
        catch (Exception e) {
            System.err.println("Error compressing proof: " + e.getMessage());
            e.printStackTrace();
            if (errStream.get() == null) return null;
            try {
                System.err.println("stderr start: -------------------------------- ");
                ((InputStream)errStream.get()).transferTo(System.err);
                System.err.println("stderr finish: ------------------------------- ");
                return null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    static {
        ProofCompressor.class.getModule().addOpens(compressorBinary.packageNameOfResource(), SingletonLoader.class.getModule());
    }
}

