/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoCreateTransactionBody;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.crypto.entities.CryptoEntitySizes;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.HookDispatchUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.handlers.BaseCryptoHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.CryptoCreateValidator;
import com.hedera.node.app.service.token.impl.validators.StakingValidator;
import com.hedera.node.app.service.token.records.CryptoCreateStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.Key;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoCreateHandler
extends BaseCryptoHandler
implements TransactionHandler {
    private static final long FIRST_SYSTEM_FILE_ENTITY = 101L;
    private static final long FIRST_POST_SYSTEM_FILE_ENTITY = 200L;
    private static final TransactionBody UPDATE_TXN_BODY_BUILDER = TransactionBody.newBuilder().cryptoUpdateAccount(CryptoUpdateTransactionBody.newBuilder().key(com.hedera.hapi.node.base.Key.newBuilder().ecdsaSecp256k1(Bytes.EMPTY).build())).build();
    private final CryptoCreateValidator cryptoCreateValidator;
    @Nullable
    private final AtomicBoolean systemEntitiesCreatedFlag;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public CryptoCreateHandler(@NonNull CryptoCreateValidator cryptoCreateValidator, @Nullable AtomicBoolean systemEntitiesCreatedFlag, @NonNull EntityIdFactory entityIdFactory) {
        this.cryptoCreateValidator = Objects.requireNonNull(cryptoCreateValidator, "The supplied argument 'cryptoCreateValidator' must not be null");
        this.systemEntitiesCreatedFlag = systemEntitiesCreatedFlag;
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        CryptoCreateTransactionBody op = txn.cryptoCreateAccountOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasAutoRenewPeriod(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_RENEWAL_PERIOD);
        PreCheckException.validateTruePreCheck((op.autoRenewPeriodOrThrow().seconds() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_RENEWAL_PERIOD);
        if (op.hasShardID()) {
            PreCheckException.validateTruePreCheck((op.shardIDOrThrow().shardNum() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (op.hasRealmID()) {
            PreCheckException.validateTruePreCheck((op.realmIDOrThrow().realmNum() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        PreCheckException.validateTruePreCheck((op.maxAutomaticTokenAssociations() >= -1 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS);
        PreCheckException.validateTruePreCheck((op.initialBalance() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_INITIAL_BALANCE);
        PreCheckException.validateTruePreCheck((op.sendRecordThreshold() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_SEND_RECORD_THRESHOLD);
        PreCheckException.validateTruePreCheck((op.receiveRecordThreshold() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_RECEIVE_RECORD_THRESHOLD);
        PreCheckException.validateTruePreCheck((boolean)op.proxyAccountIDOrElse(AccountID.DEFAULT).equals((Object)AccountID.DEFAULT), (ResponseCodeEnum)ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED);
        PreCheckException.validateFalsePreCheck((boolean)op.hasProxyAccountID(), (ResponseCodeEnum)ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED);
        Bytes alias = op.alias();
        PreCheckException.validateTruePreCheck((alias.length() == 0L || AliasUtils.isOfEvmAddressSize((Bytes)alias) || AliasUtils.isKeyAlias((Bytes)alias) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALIAS_KEY);
        com.hedera.hapi.node.base.Key key = op.key();
        boolean isInternal = !txn.hasTransactionID() || this.systemEntitiesCreatedFlag != null && !this.systemEntitiesCreatedFlag.get();
        boolean keyIsEmpty = KeyUtils.isEmpty((com.hedera.hapi.node.base.Key)key);
        if (!isInternal && keyIsEmpty) {
            if (key == null) {
                throw new PreCheckException(alias.length() > 0L ? ResponseCodeEnum.INVALID_ALIAS_KEY : ResponseCodeEnum.KEY_REQUIRED);
            }
            if (key.hasThresholdKey() || key.hasKeyList()) {
                throw new PreCheckException(ResponseCodeEnum.KEY_REQUIRED);
            }
            throw new PreCheckException(ResponseCodeEnum.BAD_ENCODING);
        }
        PreCheckException.validateTruePreCheck((key != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.KEY_NOT_PROVIDED);
        HookDispatchUtils.validateHookDuplicates((List)op.hookCreationDetails());
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        boolean receiverSigReq;
        Objects.requireNonNull(context);
        CryptoCreateTransactionBody op = context.body().cryptoCreateAccountOrThrow();
        Bytes alias = op.alias();
        if (alias.length() > 0L) {
            com.hedera.hapi.node.base.Key payerKey = context.payerKey();
            if (AliasUtils.isOfEvmAddressSize((Bytes)alias)) {
                Bytes payerEvmAddress = AliasUtils.extractEvmAddress((com.hedera.hapi.node.base.Key)payerKey);
                Bytes accountKeyEvmAddress = AliasUtils.extractEvmAddress((com.hedera.hapi.node.base.Key)op.keyOrThrow());
                if (!alias.equals((Object)payerEvmAddress) && !alias.equals((Object)accountKeyEvmAddress)) {
                    context.requireSignatureForHollowAccountCreation(alias);
                }
            } else if (context.isSyntheticTransaction()) {
                com.hedera.hapi.node.base.Key aliasAsKey = AliasUtils.asKeyFromAliasPreCheck((Bytes)alias);
                if (!aliasAsKey.equals((Object)payerKey)) {
                    context.requireKey(aliasAsKey);
                }
            } else {
                throw new PreCheckException(ResponseCodeEnum.INVALID_ALIAS_KEY);
            }
        }
        if (receiverSigReq = op.receiverSigRequired()) {
            context.requireKey(op.keyOrThrow());
        }
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context);
        TransactionBody txnBody = context.body();
        CryptoCreateTransactionBody op = txnBody.cryptoCreateAccountOrThrow();
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        boolean stillCreatingSystemEntities = this.systemEntitiesCreatedFlag != null && !this.systemEntitiesCreatedFlag.get();
        this.validateSemantics(context, accountStore, op, stillCreatingSystemEntities);
        if (op.initialBalance() > 0L && !stillCreatingSystemEntities) {
            Account payer = TokenHandlerHelper.getIfUsable(context.payer(), accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_PAYER_ACCOUNT_ID);
            long newPayerBalance = payer.tinybarBalance() - op.initialBalance();
            this.validatePayer(payer, newPayerBalance);
            Account modifiedPayer = payer.copyBuilder().tinybarBalance(newPayerBalance).build();
            accountStore.put(modifiedPayer);
        }
        int updatedSlots = 0;
        if (!op.hookCreationDetails().isEmpty()) {
            AccountID ownerId = this.entityIdFactory.newAccountId(context.entityNumGenerator().peekAtNewEntityNum());
            HookEntityId hookEntityId = HookEntityId.newBuilder().accountId(ownerId).build();
            updatedSlots = HookDispatchUtils.dispatchHookCreations((HandleContext)context, (List)op.hookCreationDetails(), null, (HookEntityId)hookEntityId);
        }
        Account accountCreated = this.buildAccount(op, context, updatedSlots);
        HandleException.validateFalse((boolean)this.isSystemFile(accountCreated.accountIdOrThrow().accountNumOrThrow()), (ResponseCodeEnum)ResponseCodeEnum.FAIL_INVALID);
        accountStore.putAndIncrementCount(accountCreated);
        AccountID createdAccountID = accountCreated.accountIdOrThrow();
        CryptoCreateStreamBuilder recordBuilder = (CryptoCreateStreamBuilder)context.savepointStack().getBaseBuilder(CryptoCreateStreamBuilder.class);
        recordBuilder.accountID(createdAccountID);
        Bytes alias = op.alias();
        if (alias.length() > 0L) {
            if (AliasUtils.isOfEvmAddressSize((Bytes)alias)) {
                accountStore.putAndIncrementCountAlias(alias, createdAccountID);
            } else {
                com.hedera.hapi.node.base.Key key = AliasUtils.asKeyFromAlias((Bytes)alias);
                HandleException.validateTrue((boolean)KeyUtils.isValid((com.hedera.hapi.node.base.Key)key), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALIAS_KEY);
                Bytes evmAddress = AliasUtils.extractEvmAddress((com.hedera.hapi.node.base.Key)key);
                if (evmAddress != null) {
                    accountStore.putAndIncrementCountAlias(evmAddress, createdAccountID);
                    recordBuilder.evmAddress(evmAddress);
                }
                accountStore.putAndIncrementCountAlias(alias, createdAccountID);
            }
        }
    }

    private void validateSemantics(@NonNull HandleContext context, @NonNull ReadableAccountStore accountStore, @NonNull CryptoCreateTransactionBody op, boolean stillCreatingSystemEntities) {
        boolean hasAlias;
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        EntitiesConfig entitiesConfig = (EntitiesConfig)context.configuration().getConfigData(EntitiesConfig.class);
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        AccountsConfig accountConfig = (AccountsConfig)context.configuration().getConfigData(AccountsConfig.class);
        HederaConfig hederaConfig = (HederaConfig)context.configuration().getConfigData(HederaConfig.class);
        Bytes alias = op.alias();
        if (op.hasShardID()) {
            HandleException.validateTrue((op.shardIDOrThrow().shardNum() == hederaConfig.shard() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (op.hasRealmID()) {
            HandleException.validateTrue((op.realmIDOrThrow().realmNum() == hederaConfig.realm() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        HandleException.validateFalse((boolean)AliasUtils.isEntityNumAlias((Bytes)alias), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ALIAS_KEY);
        if (accountStore.getNumberOfAccounts() + 1L > accountConfig.maxNumber()) {
            throw new HandleException(ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        }
        context.attributeValidator().validateMemo(op.memo());
        boolean bl = hasAlias = alias.length() > 0L;
        if (hasAlias) {
            HederaConfig config = (HederaConfig)context.configuration().getConfigData(HederaConfig.class);
            AccountID accountId = accountStore.getAccountIDByAlias(config.shard(), config.realm(), alias);
            Account account = accountId != null ? accountStore.getAccountById(accountId) : null;
            boolean isDeleted = account == null || account.deleted();
            HandleException.validateTrue((accountId == null || isDeleted ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ALIAS_ALREADY_ASSIGNED);
        }
        context.attributeValidator().validateAutoRenewPeriod(op.autoRenewPeriodOrThrow().seconds());
        HandleException.validateFalse((boolean)this.cryptoCreateValidator.tooManyAutoAssociations(op.maxAutomaticTokenAssociations(), ledgerConfig, entitiesConfig, tokensConfig), (ResponseCodeEnum)ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS);
        HandleException.validateFalse((op.hasProxyAccountID() && !op.proxyAccountIDOrThrow().equals((Object)AccountID.DEFAULT) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED);
        this.cryptoCreateValidator.validateKey(op.keyOrThrow(), context.attributeValidator(), context.savepointStack().getBaseBuilder(StreamBuilder.class).isInternalDispatch() || stillCreatingSystemEntities);
        if (op.hasStakedAccountId() || op.hasStakedNodeId()) {
            StakingValidator.validateStakedIdForCreation(op.declineReward(), ((CryptoCreateTransactionBody.StakedIdOneOfType)op.stakedId().kind()).name(), op.stakedAccountId(), op.stakedNodeId(), accountStore, context.networkInfo());
        }
    }

    private void validatePayer(@NonNull Account payer, long newPayerBalance) {
        if (payer.deleted()) {
            throw new HandleException(ResponseCodeEnum.ACCOUNT_DELETED);
        }
        if (newPayerBalance < 0L) {
            throw new HandleException(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE);
        }
    }

    @NonNull
    private Account buildAccount(CryptoCreateTransactionBody op, HandleContext handleContext, int updatedSlots) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(handleContext);
        long autoRenewPeriod = op.autoRenewPeriodOrThrow().seconds();
        long consensusTime = handleContext.consensusNow().getEpochSecond();
        long expiry = consensusTime + autoRenewPeriod;
        Account.Builder builder = Account.newBuilder().memo(op.memo()).expirationSecond(expiry).autoRenewSeconds(autoRenewPeriod).receiverSigRequired(op.receiverSigRequired()).maxAutoAssociations(op.maxAutomaticTokenAssociations()).tinybarBalance(op.initialBalance()).declineReward(op.declineReward()).key(op.keyOrThrow()).stakeAtStartOfLastRewardedPeriod(-1L).stakePeriodStart(-1L).alias(op.alias());
        if (!op.hookCreationDetails().isEmpty()) {
            builder.firstHookId(((HookCreationDetails)op.hookCreationDetails().getFirst()).hookId());
            builder.numberHooksInUse((long)op.hookCreationDetails().size());
            builder.numberLambdaStorageSlots((long)updatedSlots);
        }
        if (op.hasStakedAccountId()) {
            builder.stakedAccountId(op.stakedAccountId());
        } else if (op.hasStakedNodeId()) {
            builder.stakedNodeId(op.stakedNodeIdOrThrow().longValue());
        }
        HederaConfig hederaConfig = (HederaConfig)handleContext.configuration().getConfigData(HederaConfig.class);
        builder.accountId(AccountID.newBuilder().shardNum(hederaConfig.shard()).realmNum(hederaConfig.realm()).accountNum(handleContext.entityNumGenerator().newEntityNum()).build());
        return builder.build();
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        CryptoCreateTransactionBody op = feeContext.body().cryptoCreateAccountOrThrow();
        long keySize = op.hasKey() ? (long)FeeBuilder.getAccountKeyStorageSize((Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)op.keyOrElse(com.hedera.hapi.node.base.Key.DEFAULT))) : 0L;
        boolean unlimitedAutoAssociations = ((EntitiesConfig)feeContext.configuration().getConfigData(EntitiesConfig.class)).unlimitedAutoAssociationsEnabled();
        long maxAutoAssociationsSize = !unlimitedAutoAssociations && op.maxAutomaticTokenAssociations() > 0 ? 4L : 0L;
        long baseSize = (long)op.memo().length() + keySize + maxAutoAssociationsSize;
        long lifeTime = op.autoRenewPeriodOrElse(Duration.DEFAULT).seconds();
        FeeCalculator feeCalculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        FeeCalculator fee = feeCalculator.addBytesPerTransaction(baseSize + 16L + 4L).addRamByteSeconds(((long)CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr() + baseSize) * lifeTime).addNetworkRamByteSeconds(24L * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
        if (!unlimitedAutoAssociations && op.maxAutomaticTokenAssociations() > 0) {
            fee.addRamByteSeconds((long)op.maxAutomaticTokenAssociations() * lifeTime * 1228L);
        }
        if (!op.hookCreationDetails().isEmpty()) {
            fee.addStorageBytesSeconds((long)op.hookCreationDetails().size() * 3600L);
        }
        if (KeyUtils.IMMUTABILITY_SENTINEL_KEY.equals((Object)op.key())) {
            Fees lazyCreationFee = feeContext.dispatchComputeFees(UPDATE_TXN_BODY_BUILDER, feeContext.payer());
            return fee.calculate().plus(lazyCreationFee);
        }
        return fee.calculate();
    }

    private boolean isSystemFile(long entityNum) {
        return 101L <= entityNum && entityNum < 200L;
    }
}

