/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.entities.TokenEntitySizes;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.CustomFeeAssessmentStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContextImpl;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferExecutor;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCallsFactory;
import com.hedera.node.app.service.token.impl.validators.CryptoTransferValidator;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.WarmupContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.FeesConfig;
import com.hedera.node.config.data.HooksConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoTransferHandler
extends TransferExecutor
implements TransactionHandler {
    private final CryptoTransferValidator validator;
    private final boolean enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments;

    @Inject
    public CryptoTransferHandler(@NonNull CryptoTransferValidator validator, @NonNull HookCallsFactory hookCallsFactory, @NonNull EntityIdFactory entityIdFactory) {
        this(validator, true, hookCallsFactory, entityIdFactory);
    }

    public CryptoTransferHandler(@NonNull CryptoTransferValidator validator, boolean enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments, @NonNull HookCallsFactory hookCallsFactory, @NonNull EntityIdFactory entityIdFactory) {
        super(validator, hookCallsFactory, entityIdFactory);
        this.validator = validator;
        this.enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments = enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments;
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        CryptoTransferTransactionBody op = context.body().cryptoTransferOrThrow();
        this.preHandle(context, op);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        CryptoTransferTransactionBody op = txn.cryptoTransfer();
        PreCheckException.validateTruePreCheck((op != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        this.validator.pureChecks(op);
    }

    public void warm(@NonNull WarmupContext context) {
        Objects.requireNonNull(context);
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableNftStore nftStore = (ReadableNftStore)context.createStore(ReadableNftStore.class);
        ReadableTokenRelationStore tokenRelationStore = (ReadableTokenRelationStore)context.createStore(ReadableTokenRelationStore.class);
        CryptoTransferTransactionBody op = context.body().cryptoTransferOrThrow();
        TransferList transferList = op.transfersOrElse(TransferList.DEFAULT);
        transferList.accountAmounts().stream().map(AccountAmount::accountID).filter(Objects::nonNull).forEach(arg_0 -> ((ReadableAccountStore)accountStore).warm(arg_0));
        List tokenTransfers = op.tokenTransfers();
        tokenTransfers.stream().filter(TokenTransferList::hasToken).forEach(tokenTransferList -> {
            AccountID treasuryID;
            TokenID tokenID = tokenTransferList.tokenOrThrow();
            Token token = tokenStore.get(tokenID);
            AccountID accountID2 = treasuryID = token == null ? null : token.treasuryAccountId();
            if (treasuryID != null) {
                accountStore.warm(treasuryID);
            }
            for (AccountAmount amount : tokenTransferList.transfers()) {
                amount.ifAccountID(accountID -> tokenRelationStore.warm(accountID, tokenID));
            }
            for (NftTransfer nftTransfer : tokenTransferList.nftTransfers()) {
                this.warmNftTransfer(accountStore, tokenStore, nftStore, tokenRelationStore, tokenID, nftTransfer);
            }
        });
    }

    private void warmNftTransfer(@NonNull ReadableAccountStore accountStore, @NonNull ReadableTokenStore tokenStore, @NonNull ReadableNftStore nftStore, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull TokenID tokenID, @NonNull NftTransfer nftTransfer) {
        nftTransfer.ifSenderAccountID(senderAccountID -> {
            Account sender = accountStore.getAliasedAccountById(senderAccountID);
            if (sender != null) {
                sender.ifHeadNftId(arg_0 -> ((ReadableNftStore)nftStore).warm(arg_0));
            }
            tokenRelationStore.warm(senderAccountID, tokenID);
        });
        nftTransfer.ifReceiverAccountID(receiverAccountID -> {
            Account receiver = accountStore.getAliasedAccountById(receiverAccountID);
            if (receiver != null) {
                receiver.ifHeadTokenId(headTokenID -> {
                    tokenRelationStore.warm(receiverAccountID, headTokenID);
                    tokenStore.warm(headTokenID);
                });
                receiver.ifHeadNftId(arg_0 -> ((ReadableNftStore)nftStore).warm(arg_0));
            }
            tokenRelationStore.warm(receiverAccountID, tokenID);
        });
        Nft nft = nftStore.get(tokenID, nftTransfer.serialNumber());
        if (nft != null) {
            nft.ifOwnerPreviousNftId(arg_0 -> ((ReadableNftStore)nftStore).warm(arg_0));
            nft.ifOwnerNextNftId(arg_0 -> ((ReadableNftStore)nftStore).warm(arg_0));
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        CryptoTransferTransactionBody op = txn.cryptoTransferOrThrow();
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        AccountsConfig accountsConfig = (AccountsConfig)context.configuration().getConfigData(AccountsConfig.class);
        HooksConfig hooksConfig = (HooksConfig)context.configuration().getConfigData(HooksConfig.class);
        HandleContext.TransactionCategory transactionCategory = context.savepointStack().getBaseBuilder(StreamBuilder.class).category();
        this.validator.validateSemantics(op, ledgerConfig, accountsConfig, hooksConfig, transactionCategory);
        TransferContextImpl transferContext = new TransferContextImpl(context, this.enforceMonoServiceRestrictionsOnAutoCreationCustomFeePayments);
        CryptoTransferStreamBuilder recordBuilder = (CryptoTransferStreamBuilder)context.savepointStack().getBaseBuilder(CryptoTransferStreamBuilder.class);
        this.executeCryptoTransfer(txn, transferContext, context, recordBuilder);
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        List<AssessedCustomFee> assessedCustomFees;
        TransactionBody body = feeContext.body();
        CryptoTransferTransactionBody op = body.cryptoTransferOrThrow();
        Configuration config = feeContext.configuration();
        int tokenMultiplier = ((FeesConfig)config.getConfigData(FeesConfig.class)).tokenTransferUsageMultiplier();
        int totalXfers = op.transfersOrElse(TransferList.DEFAULT).accountAmounts().size();
        int totalTokensInvolved = 0;
        int totalTokenTransfers = 0;
        int numNftOwnershipChanges = 0;
        for (TokenTransferList tokenTransfers : op.tokenTransfers()) {
            ++totalTokensInvolved;
            totalTokenTransfers += tokenTransfers.transfers().size();
            numNftOwnershipChanges += tokenTransfers.nftTransfers().size();
        }
        int weightedTokensInvolved = tokenMultiplier * totalTokensInvolved;
        int weightedTokenXfers = tokenMultiplier * totalTokenTransfers;
        long bpt = (long)weightedTokensInvolved * 24L + (long)(weightedTokenXfers + totalXfers) * CryptoOpsUsage.LONG_ACCOUNT_AMOUNT_BYTES + TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedForUniqueTokenTransfers(numNftOwnershipChanges);
        int customFeeHbarTransfers = 0;
        int customFeeTokenTransfers = 0;
        HashSet<TokenID> involvedTokens = new HashSet<TokenID>();
        CustomFeeAssessmentStep customFeeAssessor = new CustomFeeAssessmentStep(op);
        boolean triedAndFailedToUseCustomFees = false;
        try {
            assessedCustomFees = customFeeAssessor.assessNumberOfCustomFees(feeContext);
        }
        catch (HandleException ex) {
            ResponseCodeEnum status = ex.getStatus();
            triedAndFailedToUseCustomFees = status == ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE || status == ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE || status == ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS;
            assessedCustomFees = new ArrayList<AssessedCustomFee>();
        }
        for (AssessedCustomFee fee : assessedCustomFees) {
            if (!fee.hasTokenId()) {
                ++customFeeHbarTransfers;
                continue;
            }
            ++customFeeTokenTransfers;
            involvedTokens.add(fee.tokenId());
        }
        long rbs = (long)(totalXfers += customFeeHbarTransfers) * CryptoOpsUsage.LONG_ACCOUNT_AMOUNT_BYTES + (long)TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(weightedTokensInvolved += tokenMultiplier * involvedTokens.size(), weightedTokenXfers += tokenMultiplier * customFeeTokenTransfers, numNftOwnershipChanges);
        HookInfo hookInfo = CryptoTransferHandler.getHookInfo(op);
        SubType subType = CryptoTransferHandler.getSubType(numNftOwnershipChanges, totalTokenTransfers, customFeeHbarTransfers, customFeeTokenTransfers, triedAndFailedToUseCustomFees, hookInfo.usesHooks());
        if (hookInfo.usesHooks()) {
            long effectiveGasLimit = Math.max(0L, Math.min(((ContractsConfig)config.getConfigData(ContractsConfig.class)).maxGasPerSec(), hookInfo.totalGasLimitOfHooks()));
            return feeContext.feeCalculatorFactory().feeCalculator(subType).addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1)).addStorageBytesSeconds(3600L).addGas(effectiveGasLimit).calculate();
        }
        return feeContext.feeCalculatorFactory().feeCalculator(subType).addBytesPerTransaction(bpt).addRamByteSeconds(rbs * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs()).calculate();
    }

    public static HookInfo getHookInfo(CryptoTransferTransactionBody op) {
        HookInfo hookInfo = HookInfo.NO_HOOKS;
        for (AccountAmount aa : op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            hookInfo = CryptoTransferHandler.merge(hookInfo, CryptoTransferHandler.getTotalHookGasIfAny(aa));
        }
        for (TokenTransferList ttl : op.tokenTransfers()) {
            for (AccountAmount aa : ttl.transfers()) {
                hookInfo = CryptoTransferHandler.merge(hookInfo, CryptoTransferHandler.getTotalHookGasIfAny(aa));
            }
            for (NftTransfer nft : ttl.nftTransfers()) {
                hookInfo = CryptoTransferHandler.merge(hookInfo, CryptoTransferHandler.addNftHookGas(nft));
            }
        }
        return hookInfo;
    }

    private static HookInfo getTotalHookGasIfAny(@NonNull AccountAmount aa) {
        boolean hasPreTxHook = aa.hasPreTxAllowanceHook();
        boolean hasPrePostTxHook = aa.hasPrePostTxAllowanceHook();
        if (!hasPreTxHook && !hasPrePostTxHook) {
            return HookInfo.NO_HOOKS;
        }
        long gas = 0L;
        if (hasPreTxHook) {
            gas = CommonUtils.clampedAdd((long)gas, (long)aa.preTxAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit());
        }
        if (hasPrePostTxHook) {
            long gasPerCall = aa.prePostTxAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit();
            gas = CommonUtils.clampedAdd((long)CommonUtils.clampedAdd((long)gas, (long)gasPerCall), (long)gasPerCall);
        }
        return new HookInfo(true, gas);
    }

    private static HookInfo addNftHookGas(@NonNull NftTransfer nft) {
        long gasPerCall;
        boolean hasSenderPre = nft.hasPreTxSenderAllowanceHook();
        boolean hasSenderPrePost = nft.hasPrePostTxSenderAllowanceHook();
        boolean hasReceiverPre = nft.hasPreTxReceiverAllowanceHook();
        boolean hasReceiverPrePost = nft.hasPrePostTxReceiverAllowanceHook();
        if (!(hasSenderPre || hasSenderPrePost || hasReceiverPre || hasReceiverPrePost)) {
            return HookInfo.NO_HOOKS;
        }
        long gas = 0L;
        if (hasSenderPre) {
            gas = CommonUtils.clampedAdd((long)gas, (long)nft.preTxSenderAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit());
        }
        if (hasSenderPrePost) {
            gasPerCall = nft.prePostTxSenderAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit();
            gas = CommonUtils.clampedAdd((long)CommonUtils.clampedAdd((long)gas, (long)gasPerCall), (long)gasPerCall);
        }
        if (hasReceiverPre) {
            gas = CommonUtils.clampedAdd((long)gas, (long)nft.preTxReceiverAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit());
        }
        if (hasReceiverPrePost) {
            gasPerCall = nft.prePostTxReceiverAllowanceHookOrThrow().evmHookCallOrThrow().gasLimit();
            gas = CommonUtils.clampedAdd((long)CommonUtils.clampedAdd((long)gas, (long)gasPerCall), (long)gasPerCall);
        }
        return new HookInfo(true, gas);
    }

    private static SubType getSubType(int numNftOwnershipChanges, int numFungibleTokenTransfers, int customFeeHbarTransfers, int customFeeTokenTransfers, boolean triedAndFailedToUseCustomFees, boolean withHooks) {
        if (withHooks) {
            return SubType.CRYPTO_TRANSFER_WITH_HOOKS;
        }
        if (triedAndFailedToUseCustomFees) {
            return SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
        }
        if (numNftOwnershipChanges != 0) {
            if (customFeeHbarTransfers > 0 || customFeeTokenTransfers > 0) {
                return SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES;
            }
            return SubType.TOKEN_NON_FUNGIBLE_UNIQUE;
        }
        if (numFungibleTokenTransfers != 0) {
            if (customFeeHbarTransfers > 0 || customFeeTokenTransfers > 0) {
                return SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
            }
            return SubType.TOKEN_FUNGIBLE_COMMON;
        }
        return SubType.DEFAULT;
    }

    private static HookInfo merge(HookInfo a, HookInfo b) {
        return new HookInfo(a.usesHooks() || b.usesHooks(), CommonUtils.clampedAdd((long)a.totalGasLimitOfHooks(), (long)b.totalGasLimitOfHooks()));
    }

    public record HookInfo(boolean usesHooks, long totalGasLimitOfHooks) {
        public static final HookInfo NO_HOOKS = new HookInfo(false, 0L);
    }
}

