/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.internal.codec;

import com.hedera.hapi.block.internal.BufferedBlock;
import com.hedera.hapi.block.stream.Block;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class BufferedBlockJsonCodec
implements JsonCodec<BufferedBlock> {
    @NonNull
    public BufferedBlock parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_block_number = 0L;
            Timestamp temp_closed_timestamp = null;
            boolean temp_is_proof_sent = false;
            boolean temp_is_acknowledged = false;
            Block temp_block = null;
            Timestamp temp_opened_timestamp = null;
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "blockNumber": {
                        temp_block_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "closedTimestamp": {
                        temp_closed_timestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block18;
                    }
                    case "isProofSent": {
                        temp_is_proof_sent = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "isAcknowledged": {
                        temp_is_acknowledged = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "block": {
                        temp_block = (Block)Block.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block18;
                    }
                    case "openedTimestamp": {
                        temp_opened_timestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BufferedBlock(temp_block_number, temp_closed_timestamp, temp_is_proof_sent, temp_is_acknowledged, temp_block, temp_opened_timestamp);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BufferedBlock data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.blockNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"blockNumber", (long)data.blockNumber()));
        }
        if (data.closedTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"closedTimestamp", Timestamp.JSON, (Object)data.closedTimestamp()));
        }
        if (data.isProofSent()) {
            fieldLines.add(JsonTools.field((String)"isProofSent", (boolean)data.isProofSent()));
        }
        if (data.isAcknowledged()) {
            fieldLines.add(JsonTools.field((String)"isAcknowledged", (boolean)data.isAcknowledged()));
        }
        if (data.block() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"block", Block.JSON, (Object)data.block()));
        }
        if (data.openedTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"openedTimestamp", Timestamp.JSON, (Object)data.openedTimestamp()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

