/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.block.api.ServerStatusRequest;
import org.hiero.block.api.ServerStatusResponse;

public interface BlockNodeServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "BlockNodeService";
    public static final String FULL_NAME = "org.hiero.block.api.BlockNodeService";

    @NonNull
    public ServerStatusResponse serverStatus(@NonNull ServerStatusRequest var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(BlockNodeServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        BlockNodeServiceMethod m = (BlockNodeServiceMethod)method;
        try {
            switch (m.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Pipelines.unary().mapRequest(bytes -> BlockNodeServiceInterface.parseServerStatusRequest(bytes, options)).method(this::serverStatus).mapResponse(reply -> BlockNodeServiceInterface.serializeServerStatusResponse(reply, options)).respondTo(replies).build();
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<ServerStatusRequest> getServerStatusRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return ServerStatusRequest.JSON;
        }
        return ServerStatusRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<ServerStatusResponse> getServerStatusResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return ServerStatusResponse.JSON;
        }
        return ServerStatusResponse.PROTOBUF;
    }

    @NonNull
    private static ServerStatusRequest parseServerStatusRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (ServerStatusRequest)BlockNodeServiceInterface.getServerStatusRequestCodec(options).parse(message.toReadableSequentialData(), false, false, 16, options.maxMessageSizeBytes());
    }

    @NonNull
    private static Bytes serializeServerStatusResponse(@NonNull ServerStatusResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return BlockNodeServiceInterface.getServerStatusResponseCodec(options).toBytes((Object)reply);
    }

    public static enum BlockNodeServiceMethod implements ServiceInterface.Method
    {
        serverStatus;

    }

    public static class BlockNodeServiceClient
    implements BlockNodeServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public BlockNodeServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public ServerStatusResponse serverStatus(@NonNull ServerStatusRequest request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<ServerStatusResponse> pipeline = new Pipeline<ServerStatusResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(ServerStatusResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("serverStatus is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.BlockNodeService/serverStatus", BlockNodeServiceInterface.getServerStatusRequestCodec(this.requestOptions), BlockNodeServiceInterface.getServerStatusResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (ServerStatusResponse)replyRef.get();
            }
            throw new RuntimeException("Call to serverStatus completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

