/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleFeeCharging
implements FeeCharging {
    private final Supplier<FeeCharging> baseFeeCharging;

    @Inject
    public ScheduleFeeCharging(@NonNull Supplier<FeeCharging> baseFeeCharging) {
        this.baseFeeCharging = Objects.requireNonNull(baseFeeCharging);
    }

    public FeeCharging.Validation validate(@NonNull Account payer, @NonNull AccountID creatorId, @NonNull Fees fees, @NonNull TransactionBody body, boolean isDuplicate, @NonNull HederaFunctionality function, @NonNull HandleContext.TransactionCategory category) {
        Objects.requireNonNull(payer);
        Objects.requireNonNull(creatorId);
        Objects.requireNonNull(fees);
        Objects.requireNonNull(body);
        Objects.requireNonNull(function);
        Objects.requireNonNull(category);
        return this.baseFeeCharging.get().validate(payer, creatorId, fees.onlyServiceComponent(), body, isDuplicate, function, category);
    }

    public Fees charge(@NonNull AccountID payerId, @NonNull FeeCharging.Context ctx, @NonNull FeeCharging.Validation validation, @NonNull Fees fees) {
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(validation);
        Objects.requireNonNull(fees);
        return this.baseFeeCharging.get().charge(payerId, ctx, validation, fees.onlyServiceComponent());
    }

    public void refund(@NonNull AccountID payerId, @NonNull FeeCharging.Context ctx, @NonNull Fees fees) {
        Objects.requireNonNull(payerId);
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(fees);
        this.baseFeeCharging.get().refund(payerId, ctx, fees.onlyServiceComponent());
    }
}

