/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.common.types.AnnotationPropertyImpl;
import io.helidon.common.types.EnumValue;
import io.helidon.common.types.EnumValueImpl;
import io.helidon.common.types.TypeName;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public interface AnnotationProperty {
    public static AnnotationProperty create(Object value) {
        Objects.requireNonNull(value);
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnnotationProperty.class, EnumValue.class, Enum.class}, (Object)object2, n)) {
            case 0 -> {
                AnnotationProperty ap = (AnnotationProperty)object2;
                throw new IllegalArgumentException("Cannot use an existing annotation property to create a new one., value: " + String.valueOf(value) + ", inlined value: " + String.valueOf(ap.value()));
            }
            case 1 -> {
                EnumValue ev = (EnumValue)object2;
                yield new AnnotationPropertyImpl(value, ev);
            }
            case 2 -> {
                Enum en = (Enum)object2;
                yield new AnnotationPropertyImpl(value, EnumValue.create(en.getDeclaringClass(), en));
            }
            default -> new AnnotationPropertyImpl(value);
        };
    }

    public static AnnotationProperty create(Object value, TypeName constantType, String constantName) {
        EnumValue ev;
        Objects.requireNonNull(value);
        Objects.requireNonNull(constantType);
        Objects.requireNonNull(constantName);
        if (value instanceof AnnotationProperty) {
            throw new IllegalArgumentException("Cannot use an existing annotation property to create a new one. Value: " + String.valueOf(value));
        }
        if (!(!(value instanceof EnumValue) || (ev = (EnumValue)value).type().equals(constantType) && ev.name().equals(constantName))) {
            throw new IllegalArgumentException("Inconsistent annotation value vs. its constant value, an enum must use an enum constant. Enum: " + String.valueOf(ev) + ", Constant: " + constantType.fqName() + "." + constantName);
        }
        return new AnnotationPropertyImpl(value, new EnumValueImpl(constantType, constantName));
    }

    public static <T extends Enum<T>> AnnotationProperty create(Class<T> type, T value) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(value);
        return AnnotationProperty.create(EnumValue.create(type, value));
    }

    public Object value();

    public Optional<ConstantValue> constantValue();

    public static interface ConstantValue {
        public TypeName type();

        public String name();
    }
}

