/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.exceptions.BadIOException;
import org.hiero.consensus.gossip.config.SocketConfig;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncInputStream;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncOutputStream;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.ConnectionTracker;
import org.hiero.consensus.gossip.impl.network.NetworkUtils;
import org.hiero.consensus.model.node.NodeId;

public class SocketConnection
implements Connection {
    private static final Logger logger = LogManager.getLogger(SocketConnection.class);
    private final NodeId selfId;
    private final NodeId otherId;
    private final SyncInputStream dis;
    private final SyncOutputStream dos;
    private final Socket socket;
    private final ConnectionTracker connectionTracker;
    private final AtomicBoolean connected = new AtomicBoolean(true);
    private final boolean outbound;
    private final String description;
    private final Configuration configuration;

    protected SocketConnection(NodeId selfId, NodeId otherId, ConnectionTracker connectionTracker, boolean outbound, Socket socket, SyncInputStream dis, SyncOutputStream dos, Configuration configuration) {
        Objects.requireNonNull(socket);
        Objects.requireNonNull(dis);
        Objects.requireNonNull(dos);
        Objects.requireNonNull(configuration);
        this.selfId = selfId;
        this.otherId = otherId;
        this.connectionTracker = connectionTracker;
        this.outbound = outbound;
        this.description = this.generateDescription();
        this.socket = socket;
        this.dis = dis;
        this.dos = dos;
        this.configuration = configuration;
    }

    public static SocketConnection create(NodeId selfId, NodeId otherId, ConnectionTracker connectionTracker, boolean outbound, Socket socket, SyncInputStream dis, SyncOutputStream dos, Configuration configuration) {
        SocketConnection c = new SocketConnection(selfId, otherId, connectionTracker, outbound, socket, dis, dos, configuration);
        connectionTracker.newConnectionOpened(c);
        return c;
    }

    @Override
    public NodeId getSelfId() {
        return this.selfId;
    }

    @Override
    public NodeId getOtherId() {
        return this.otherId;
    }

    @Override
    public SyncInputStream getDis() {
        return this.dis;
    }

    @Override
    public SyncOutputStream getDos() {
        return this.dos;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(long timeoutMillis) throws SocketException {
        this.socket.setSoTimeout(timeoutMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeoutMillis);
    }

    @Override
    public void disconnect() {
        boolean wasConnected = this.connected.getAndSet(false);
        if (wasConnected) {
            this.connectionTracker.connectionClosed(this.isOutbound(), this);
        }
        logger.debug(LogMarker.NETWORK.getMarker(), "disconnecting connection from {} to {}", (Object)this.selfId, (Object)this.otherId);
        NetworkUtils.close(new Closeable[]{this.socket, this.dis, this.dos});
    }

    @Override
    public boolean connected() {
        try {
            if (!this.socket.isClosed() && this.socket.isBound() && this.socket.isConnected()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Connection.connected error on connection from {} to {}", (Object)this.selfId, (Object)this.otherId, (Object)e);
        }
        return false;
    }

    @Override
    public void initForSync() throws IOException {
        if (!this.connected()) {
            throw new BadIOException("not a valid connection ");
        }
        this.getDis().getSyncByteCounter().resetCount();
        this.getDos().getSyncByteCounter().resetCount();
        SocketConfig socketConfig = (SocketConfig)this.configuration.getConfigData(SocketConfig.class);
        this.setTimeout(socketConfig.timeoutSyncClientSocket());
    }

    @Override
    public boolean isOutbound() {
        return this.outbound;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

