/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.communication;

import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncInputStream;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncOutputStream;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationException;
import org.hiero.consensus.gossip.impl.network.communication.NegotiationProtocols;
import org.hiero.consensus.gossip.impl.network.communication.states.InitialState;
import org.hiero.consensus.gossip.impl.network.communication.states.NegotiationState;
import org.hiero.consensus.gossip.impl.network.communication.states.ProtocolNegotiated;
import org.hiero.consensus.gossip.impl.network.communication.states.ReceivedInitiate;
import org.hiero.consensus.gossip.impl.network.communication.states.SentInitiate;
import org.hiero.consensus.gossip.impl.network.communication.states.SentKeepalive;
import org.hiero.consensus.gossip.impl.network.communication.states.Sleep;
import org.hiero.consensus.gossip.impl.network.communication.states.WaitForAcceptReject;

public class Negotiator {
    private static final Logger logger = LogManager.getLogger(Negotiator.class);
    private final NegotiationProtocols protocols;
    private final NegotiationState initialState;
    private final ProtocolNegotiated protocolNegotiated;
    private final Sleep sleep;
    private boolean errorState;
    private final String negotiatorName;

    public Negotiator(NegotiationProtocols protocols, Connection connection, int sleepMs) {
        this.protocols = protocols;
        this.protocolNegotiated = new ProtocolNegotiated(connection);
        this.sleep = new Sleep(sleepMs);
        SyncInputStream in = connection.getDis();
        SyncOutputStream out = connection.getDos();
        ReceivedInitiate receivedInitiate = new ReceivedInitiate(protocols, (OutputStream)((Object)out), this.protocolNegotiated, this.sleep);
        WaitForAcceptReject waitForAcceptReject = new WaitForAcceptReject(protocols, (InputStream)((Object)in), this.protocolNegotiated, this.sleep);
        SentInitiate sentInitiate = new SentInitiate(protocols, (InputStream)((Object)in), this.protocolNegotiated, receivedInitiate, waitForAcceptReject, this.sleep);
        SentKeepalive sentKeepalive = new SentKeepalive((InputStream)((Object)in), this.sleep, receivedInitiate);
        this.initialState = new InitialState(protocols, (OutputStream)((Object)out), sentKeepalive, sentInitiate);
        this.errorState = false;
        this.negotiatorName = connection.getDescription();
    }

    public void execute() throws InterruptedException, NegotiationException, NetworkProtocolException, IOException {
        if (this.errorState) {
            throw new IllegalStateException();
        }
        NegotiationState prev = null;
        for (NegotiationState current = this.initialState; current != null; current = current.transition()) {
            try {
                prev = current;
                logger.debug(LogMarker.PROTOCOL_NEGOTIATION.getMarker(), "Negotiator {} last transition: {}", (Object)this.negotiatorName, (Object)prev.getLastTransitionDescription());
                continue;
            }
            catch (IOException | InterruptedException | RuntimeException | NetworkProtocolException | NegotiationException e) {
                this.errorState = true;
                this.protocols.negotiationExceptionOccurred();
                throw e;
            }
        }
        if (prev != this.sleep && prev != this.protocolNegotiated) {
            throw new NegotiationException("The outcome should always be sleep or running a protocol");
        }
    }
}

