/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.binary.QueueState;
import com.swirlds.state.merkle.disk.OnDiskQueueHelper;
import com.swirlds.state.spi.ReadableQueueStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;

public class OnDiskReadableQueueState<V>
extends ReadableQueueStateBase<V> {
    @NonNull
    private final OnDiskQueueHelper<V> onDiskQueueHelper;

    public OnDiskReadableQueueState(int stateId, @NonNull String label, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, label);
        this.onDiskQueueHelper = new OnDiskQueueHelper<V>(stateId, valueCodec, virtualMap);
    }

    @Nullable
    protected V peekOnDataSource() {
        QueueState state = this.onDiskQueueHelper.getState();
        Objects.requireNonNull(state);
        return OnDiskQueueHelper.isEmpty(state) ? null : (V)this.onDiskQueueHelper.getFromStore(state.head());
    }

    @NonNull
    protected Iterator<V> iterateOnDataSource() {
        QueueState state = this.onDiskQueueHelper.getState();
        if (state == null) {
            return this.onDiskQueueHelper.iterateOnDataSource(0L, 0L);
        }
        return this.onDiskQueueHelper.iterateOnDataSource(state.head(), state.tail());
    }
}

