/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.disk;

import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.binary.QueueState;
import com.swirlds.state.merkle.disk.OnDiskQueueHelper;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;

public class OnDiskWritableQueueState<V>
extends WritableQueueStateBase<V> {
    @NonNull
    private final OnDiskQueueHelper<V> onDiskQueueHelper;

    public OnDiskWritableQueueState(int stateId, @NonNull String label, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, Objects.requireNonNull(label));
        this.onDiskQueueHelper = new OnDiskQueueHelper<V>(stateId, valueCodec, virtualMap);
    }

    protected void addToDataSource(@NonNull V value) {
        QueueState state = this.onDiskQueueHelper.getState();
        if (state == null) {
            state = new QueueState(1L, 1L);
        }
        this.onDiskQueueHelper.addToStore(state.tail(), value);
        this.onDiskQueueHelper.updateState(state.elementAdded());
    }

    protected void removeFromDataSource() {
        QueueState state = Objects.requireNonNull(this.onDiskQueueHelper.getState());
        if (!OnDiskQueueHelper.isEmpty(state)) {
            this.onDiskQueueHelper.removeFromStore(state.head());
            this.onDiskQueueHelper.updateState(state.elementRemoved());
        }
    }

    @NonNull
    protected Iterator<V> iterateOnDataSource() {
        QueueState state = this.onDiskQueueHelper.getState();
        if (state == null) {
            return this.onDiskQueueHelper.iterateOnDataSource(0L, 0L);
        }
        return this.onDiskQueueHelper.iterateOnDataSource(state.head(), state.tail());
    }
}

