/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.metrics.impl;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultLongGauge
extends AbstractMetric
implements LongGauge {
    private final AtomicLong value;

    public DefaultLongGauge(@NonNull LongGauge.Config config) {
        super((MetricConfig<?, ?>)config);
        this.value = new AtomicLong(config.getInitialValue());
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.get()));
    }

    public long get() {
        return this.value.get();
    }

    public void set(long newValue) {
        this.value.set(newValue);
    }

    public void add(long change) {
        this.value.addAndGet(change);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.value.get()).toString();
    }
}

