/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl.linking;

import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.hashgraph.impl.EventImpl;
import org.hiero.consensus.hashgraph.impl.linking.LinkerLogsAndMetrics;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;

public class DefaultLinkerLogsAndMetrics
implements LinkerLogsAndMetrics {
    private static final Duration MINIMUM_LOG_PERIOD = Duration.ofMinutes(1L);
    private static final Logger logger = LogManager.getLogger(DefaultLinkerLogsAndMetrics.class);
    private final RateLimitedLogger missingParentLogger;
    private final RateLimitedLogger birthRoundMismatchLogger;
    private final RateLimitedLogger timeCreatedMismatchLogger;
    private final LongAccumulator missingParentAccumulator;
    private final LongAccumulator birthRoundMismatchAccumulator;
    private final LongAccumulator timeCreatedMismatchAccumulator;

    public DefaultLinkerLogsAndMetrics(@NonNull Metrics metrics, @NonNull Time time) {
        this.missingParentLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.birthRoundMismatchLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.timeCreatedMismatchLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.missingParentAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "missingParents").withDescription("Parent child relationships where a parent was missing"));
        this.birthRoundMismatchAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "parentBirthRoundMismatch").withDescription("Parent child relationships where claimed parent birth round did not match actual parent birth round"));
        this.timeCreatedMismatchAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "timeCreatedMismatch").withDescription("Parent child relationships where child time created wasn't strictly after parent time created"));
    }

    @Override
    public void childHasMissingParent(@NonNull PlatformEvent child, @NonNull EventDescriptorWrapper parentDescriptor) {
        this.missingParentLogger.error(LogMarker.EXCEPTION.getMarker(), "Child has a missing parent. This should not be possible. Child: {}, Parent EventDescriptor: {}", new Object[]{child, parentDescriptor});
        this.missingParentAccumulator.update(1L);
    }

    @Override
    public void parentHasIncorrectBirthRound(@NonNull PlatformEvent child, @NonNull EventDescriptorWrapper parentDescriptor, @NonNull EventImpl candidateParent) {
        this.birthRoundMismatchLogger.warn(LogMarker.EXCEPTION.getMarker(), "Event has a parent with a different birth round than claimed. Child: {}, parent: {}, claimed birth round: {}, actual birth round: {}", new Object[]{child, candidateParent, parentDescriptor.eventDescriptor().birthRound(), candidateParent.getBirthRound()});
        this.birthRoundMismatchAccumulator.update(1L);
    }

    @Override
    public void childTimeIsNotAfterSelfParentTime(@NonNull PlatformEvent child, @NonNull EventImpl candidateParent, @NonNull Instant parentTimeCreated, @NonNull Instant childTimeCreated) {
        this.timeCreatedMismatchLogger.error(LogMarker.EXCEPTION.getMarker(), "Child time created isn't strictly after self parent time created. Child: {}, parent: {}, child time created: {}, parent time created: {}", new Object[]{child, candidateParent, childTimeCreated, parentTimeCreated});
        this.timeCreatedMismatchAccumulator.update(1L);
    }
}

