/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.signed.SignedStateValidationData;
import com.swirlds.platform.state.signed.SignedStateValidator;
import com.swirlds.state.State;
import com.swirlds.state.merkle.VirtualMapState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.signed.SignedStateInvalidException;

public class DefaultSignedStateValidator
implements SignedStateValidator {
    private static final Logger logger = LogManager.getLogger(DefaultSignedStateValidator.class);

    @Override
    public void validate(SignedState signedState, Roster roster, SignedStateValidationData previousStateData) {
        this.throwIfOld(signedState, previousStateData);
        signedState.pruneInvalidSignatures(roster);
        signedState.throwIfNotVerifiable();
    }

    private void throwIfOld(SignedState signedState, SignedStateValidationData previousStateData) throws SignedStateInvalidException {
        VirtualMapState state = signedState.getState();
        if (PlatformStateUtils.roundOf((State)state) < previousStateData.round() || PlatformStateUtils.consensusTimestampOf((State)state).isBefore(previousStateData.consensusTimestamp())) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "State is too old. Failed reconnect state:\n{}\nOriginal reconnect state:\n{}", (Object)PlatformStateUtils.getInfoString((State)state), (Object)previousStateData.getInfoString());
            throw new SignedStateInvalidException("Received signed state is for a round smaller than or a consensus earlier than what we started with. Original round %d, received round %d. Original timestamp %s, received timestamp %s.".formatted(previousStateData.round(), signedState.getRound(), previousStateData.consensusTimestamp(), signedState.getConsensusTimestamp()));
        }
    }
}

