/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signed;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.roster.RosterUtils;

public record SignedStateValidationData(long round, @NonNull Instant consensusTimestamp, @Nullable Hash rosterHash, @NonNull Hash consensusEventsRunningHash) {
    public SignedStateValidationData {
        Objects.requireNonNull(consensusTimestamp);
        Objects.requireNonNull(consensusEventsRunningHash);
    }

    public SignedStateValidationData(@NonNull State that, @Nullable Roster roster) {
        this(PlatformStateUtils.roundOf((State)that), Optional.ofNullable(PlatformStateUtils.consensusTimestampOf((State)that)).orElse(Instant.EPOCH), roster == null ? null : RosterUtils.hash((Roster)roster), Optional.ofNullable(PlatformStateUtils.legacyRunningEventHashOf((State)that)).orElse(new Hash()));
    }

    public String getInfoString() {
        return "Round = " + this.round + ", consensus timestamp = " + this.consensusTimestamp + ", consensus Events running hash = " + this.consensusEventsRunningHash + ", roster hash = " + (this.rosterHash != null ? this.rosterHash : "not provided");
    }
}

