/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.base.utility.ToStringBuilder;
import java.util.Objects;

public class VirtualMapMetadata {
    private long firstLeafPath;
    private long lastLeafPath;

    public VirtualMapMetadata() {
        this.firstLeafPath = -1L;
        this.lastLeafPath = -1L;
    }

    public VirtualMapMetadata(long firstLeafPath, long lastLeafPath) {
        this.firstLeafPath = firstLeafPath;
        this.lastLeafPath = lastLeafPath;
    }

    public VirtualMapMetadata(long stateSize) {
        if (stateSize == 0L) {
            this.firstLeafPath = -1L;
            this.lastLeafPath = -1L;
        }
        if (stateSize == 1L) {
            this.firstLeafPath = 1L;
            this.lastLeafPath = 1L;
        } else {
            this.firstLeafPath = stateSize - 1L;
            this.lastLeafPath = this.firstLeafPath + stateSize - 1L;
        }
    }

    private VirtualMapMetadata(VirtualMapMetadata virtualMapMetadata) {
        this.firstLeafPath = virtualMapMetadata.getFirstLeafPath();
        this.lastLeafPath = virtualMapMetadata.getLastLeafPath();
    }

    public long getFirstLeafPath() {
        return this.firstLeafPath;
    }

    public void setFirstLeafPath(long path) {
        if (path < 1L && path != -1L) {
            throw new IllegalArgumentException("The path must be positive, or INVALID_PATH, but was " + path);
        }
        if (path > this.lastLeafPath) {
            throw new IllegalArgumentException("The firstLeafPath must be less than or equal to the lastLeafPath");
        }
        this.firstLeafPath = path;
    }

    public long getLastLeafPath() {
        return this.lastLeafPath;
    }

    public void setLastLeafPath(long path) {
        if (path < 1L && path != -1L) {
            throw new IllegalArgumentException("The path must be positive, or INVALID_PATH, but was " + path);
        }
        if (path < this.firstLeafPath && path != -1L) {
            throw new IllegalArgumentException("The lastLeafPath must be greater than or equal to the firstLeafPath");
        }
        this.lastLeafPath = path;
    }

    public long getSize() {
        if (this.firstLeafPath == -1L) {
            return 0L;
        }
        return this.lastLeafPath - this.firstLeafPath + 1L;
    }

    public VirtualMapMetadata copy() {
        return new VirtualMapMetadata(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("firstLeafPath", (Object)this.firstLeafPath).append("lastLeafPath", (Object)this.lastLeafPath).append("size", (Object)this.getSize()).toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualMapMetadata that = (VirtualMapMetadata)o;
        return this.firstLeafPath == that.firstLeafPath && this.lastLeafPath == that.lastLeafPath;
    }

    public int hashCode() {
        return Objects.hash(this.firstLeafPath, this.lastLeafPath);
    }
}

