/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.task;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.InternalDataLesson;
import com.swirlds.common.merkle.synchronization.task.LeafDataLesson;
import com.swirlds.common.merkle.synchronization.task.Lesson;
import com.swirlds.common.merkle.synchronization.task.QueryResponse;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.reconnect.config.ReconnectConfig;

public class TeacherPushSendTask {
    private static final Logger logger = LogManager.getLogger(TeacherPushSendTask.class);
    private static final String NAME = "teacher-send-task";
    private static final Lesson UP_TO_DATE_LESSON = new Lesson(0, null);
    private final StandardWorkGroup workGroup;
    private final AsyncInputStream<QueryResponse> in;
    private final AsyncOutputStream<Lesson> out;
    private final TeacherTreeView view;
    private final AtomicBoolean senderIsFinished;
    private final RateLimiter rateLimiter;
    private final int sleepNanos;

    public TeacherPushSendTask(@NonNull Time time, @NonNull ReconnectConfig reconnectConfig, StandardWorkGroup workGroup, AsyncInputStream<QueryResponse> in, AsyncOutputStream<Lesson> out, TeacherTreeView view, AtomicBoolean senderIsFinished) {
        this.workGroup = workGroup;
        this.in = in;
        this.out = out;
        this.view = view;
        this.senderIsFinished = senderIsFinished;
        int maxRate = reconnectConfig.teacherMaxNodesPerSecond();
        if (maxRate > 0) {
            this.rateLimiter = new RateLimiter(time, (double)maxRate);
            this.sleepNanos = (int)reconnectConfig.teacherRateLimiterSleep().toNanos();
        } else {
            this.rateLimiter = null;
            this.sleepNanos = -1;
        }
    }

    public void start() {
        this.workGroup.execute(NAME, this::run);
    }

    private void prepareForQueryResponse(long parent, int childIndex) {
        this.in.anticipateMessage();
        long child = this.view.getChildAndPrepareForQueryResponse(parent, childIndex);
        this.view.addToHandleQueue(child);
    }

    private Lesson buildDataLesson(long node) {
        Lesson lesson;
        if (this.view.isInternal(node, true)) {
            lesson = new Lesson(2, new InternalDataLesson(this.view, node));
            int childCount = this.view.getNumberOfChildren(node);
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                this.prepareForQueryResponse(node, childIndex);
            }
        } else {
            lesson = new Lesson(1, new LeafDataLesson(this.view, node));
        }
        return lesson;
    }

    private void sendLesson(long node) throws InterruptedException {
        boolean learnerHasConfirmed = this.view.hasLearnerConfirmedFor(node);
        Lesson lesson = learnerHasConfirmed ? UP_TO_DATE_LESSON : this.buildDataLesson(node);
        this.out.sendAsync(lesson);
    }

    private void rateLimit() throws InterruptedException {
        if (this.rateLimiter != null) {
            while (!this.rateLimiter.requestAndTrigger()) {
                TimeUnit.NANOSECONDS.sleep(this.sleepNanos);
            }
        }
    }

    private void run() {
        try (AsyncOutputStream<Lesson> asyncOutputStream = this.out;){
            this.out.sendAsync(this.buildDataLesson(0L));
            while (this.view.areThereNodesToHandle()) {
                this.rateLimit();
                long node = this.view.getNextNodeToHandle();
                this.sendLesson(node);
            }
        }
        catch (InterruptedException ex) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "teacher's sending thread interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new MerkleSynchronizationException("exception in the teacher's receiving thread", ex);
        }
        finally {
            this.senderIsFinished.set(true);
        }
    }
}

