/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.gossip.shadowgraph;

import com.hedera.hapi.platform.event.GossipEvent;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.CompareTo;
import org.hiero.base.concurrent.ThrowingRunnable;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.gossip.impl.gossip.SyncException;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowEvent;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.SyncLogging;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.SyncTimeoutException;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.TheirTipsAndEventWindow;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncMetrics;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.LinkedEvent;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public final class SyncUtils {
    private static final Logger logger = LogManager.getLogger();

    private SyncUtils() {
    }

    public static ThrowingRunnable writeMyTipsAndEventWindow(@NonNull Connection connection, @NonNull EventWindow eventWindow, @NonNull List<ShadowEvent> tips) {
        return () -> {
            List<Hash> tipHashes = tips.stream().map(LinkedEvent::getBaseHash).collect(Collectors.toList());
            SyncUtils.serializeEventWindow(connection.getDos(), eventWindow);
            connection.getDos().writeTipHashes(tipHashes);
            connection.getDos().flush();
            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = connection::getDescription;
                supplierArray[1] = () -> ((EventWindow)eventWindow).toString();
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} sent event window: {}", supplierArray);
                Supplier[] supplierArray2 = new Supplier[2];
                supplierArray2[0] = connection::getDescription;
                supplierArray2[1] = () -> SyncLogging.toShortShadows(tips);
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} sent tips: {}", supplierArray2);
            }
        };
    }

    public static Callable<TheirTipsAndEventWindow> readTheirTipsAndEventWindow(Connection connection, int numberOfNodes) {
        return () -> {
            EventWindow eventWindow = SyncUtils.deserializeEventWindow(connection.getDis());
            List<Hash> tips = connection.getDis().readTipHashes(numberOfNodes);
            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = connection::getDescription;
                supplierArray[1] = () -> ((EventWindow)eventWindow).toString();
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} received event window: {}", supplierArray);
                Supplier[] supplierArray2 = new Supplier[2];
                supplierArray2[0] = connection::getDescription;
                supplierArray2[1] = () -> SyncLogging.toShortHashes(tips);
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} received tips: {}", supplierArray2);
            }
            return new TheirTipsAndEventWindow(eventWindow, tips);
        };
    }

    public static ThrowingRunnable writeTheirTipsIHave(Connection connection, List<Boolean> theirTipsIHave, boolean ignoreIncomingEvents) {
        return () -> {
            connection.getDos().writeBoolean(ignoreIncomingEvents);
            connection.getDos().writeBooleanList(theirTipsIHave);
            connection.getDos().flush();
            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = connection::getDescription;
                supplierArray[1] = () -> SyncLogging.toShortBooleans(theirTipsIHave);
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} sent booleans: {}", supplierArray);
            }
        };
    }

    public static Callable<TipsInfo> readMyTipsTheyHave(Connection connection, int numberOfTips) {
        return () -> {
            boolean dontSendEvents = connection.getDis().readBoolean();
            List booleans = connection.getDis().readBooleanList(numberOfTips);
            if (booleans == null) {
                throw new SyncException(connection, "peer sent null booleans");
            }
            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = connection::getDescription;
                supplierArray[1] = () -> SyncLogging.toShortBooleans(booleans);
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} received booleans: {}", supplierArray);
            }
            return new TipsInfo(dontSendEvents, booleans);
        };
    }

    public static ThrowingRunnable sendEventsTheyNeed(Connection connection, List<PlatformEvent> events, CountDownLatch eventReadingDone, AtomicBoolean writeAborted, Duration syncKeepalivePeriod) {
        return () -> {
            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} writing events start. send list size: {}", (Object)connection.getDescription(), (Object)events.size());
            }
            for (PlatformEvent event : events) {
                connection.getDos().writeByte(72);
                connection.getDos().writePbjRecord(event.getGossipEvent(), GossipEvent.PROTOBUF);
            }
            if (writeAborted.get()) {
                logger.info(LogMarker.SYNC_INFO.getMarker(), "{} writing events aborted", (Object)connection.getDescription());
            } else {
                if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                    logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} writing events done, wrote {} events", (Object)connection.getDescription(), (Object)events.size());
                }
                connection.getDos().writeByte(74);
            }
            connection.getDos().flush();
            while (!eventReadingDone.await(syncKeepalivePeriod.toMillis(), TimeUnit.MILLISECONDS)) {
                connection.getDos().writeByte(70);
                connection.getDos().flush();
            }
            connection.getDos().writeByte(69);
            connection.getDos().flush();
            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} sent COMM_SYNC_DONE", (Object)connection.getDescription());
            }
        };
    }

    public static Callable<Integer> readEventsINeed(Connection connection, Consumer<PlatformEvent> eventHandler, int maxEventCount, SyncMetrics syncMetrics, CountDownLatch eventReadingDone, @NonNull IntakeEventCounter intakeEventCounter, @NonNull Duration maxSyncTime, boolean ignoreIncomingEvents) {
        return () -> {
            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} reading events start", (Object)connection.getDescription());
            }
            int eventsRead = 0;
            try {
                long startTime = System.nanoTime();
                int count = 0;
                boolean firstWrongEvent = false;
                block11: while (true) {
                    byte next = connection.getDis().readByte();
                    SyncUtils.checkEventExchangeTime(maxSyncTime, startTime);
                    switch (next) {
                        case 72: {
                            if (maxEventCount > 0 && ++count > maxEventCount) {
                                throw new IOException("max event count " + maxEventCount + " exceeded");
                            }
                            GossipEvent gossipEvent = (GossipEvent)connection.getDis().readPbjRecord(GossipEvent.PROTOBUF);
                            if (ignoreIncomingEvents) {
                                if (firstWrongEvent) continue block11;
                                logger.warn(LogMarker.SYNC_INFO.getMarker(), "We have asked for no events, but still received an event from {}", (Object)connection.getDescription());
                                firstWrongEvent = true;
                                break;
                            }
                            PlatformEvent platformEvent = new PlatformEvent(gossipEvent);
                            platformEvent.setSenderId(connection.getOtherId());
                            intakeEventCounter.eventEnteredIntakePipeline(connection.getOtherId());
                            eventHandler.accept(platformEvent);
                            ++eventsRead;
                            break;
                        }
                        case 73: {
                            logger.info(LogMarker.SYNC_INFO.getMarker(), "{} reading events aborted", (Object)connection.getDescription());
                            eventReadingDone.countDown();
                            eventsRead = Integer.MIN_VALUE;
                            break;
                        }
                        case 74: {
                            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} reading events done, read {} events", (Object)connection.getDescription(), (Object)eventsRead);
                            }
                            syncMetrics.eventsReceived(startTime, eventsRead);
                            eventReadingDone.countDown();
                            break;
                        }
                        case 70: {
                            if (!logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) continue block11;
                            logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} received COMM_SYNC_ONGOING", (Object)connection.getDescription());
                            break;
                        }
                        case 69: {
                            if (logger.isDebugEnabled(LogMarker.SYNC_INFO.getMarker())) {
                                logger.debug(LogMarker.SYNC_INFO.getMarker(), "{} received COMM_SYNC_DONE", (Object)connection.getDescription());
                            }
                            Integer n = eventsRead;
                            return n;
                        }
                        default: {
                            throw new SyncException(connection, String.format("while reading events, received unexpected byte %02x", next));
                        }
                    }
                }
            }
            finally {
                eventReadingDone.countDown();
            }
        };
    }

    private static void checkEventExchangeTime(@NonNull Duration maxSyncTime, long startTime) throws SyncTimeoutException {
        long syncTime = System.nanoTime() - startTime;
        if (syncTime > maxSyncTime.toNanos()) {
            throw new SyncTimeoutException(Duration.ofNanos(syncTime), maxSyncTime);
        }
    }

    @NonNull
    public static List<PlatformEvent> filterLikelyDuplicates(@NonNull NodeId selfId, @NonNull Duration nonAncestorThreshold, @NonNull Duration ancestorFilterThreshold, @NonNull Duration selfFilterThreshold, @NonNull Instant now, @NonNull List<PlatformEvent> eventsTheyNeed) {
        LinkedList<PlatformEvent> filteredList = new LinkedList<PlatformEvent>();
        HashSet<Hash> parentHashesOfEventsToSend = new HashSet<Hash>();
        for (int index = eventsTheyNeed.size() - 1; index >= 0; --index) {
            boolean alwaysRecurse;
            Duration needsToBeAtLeastThatOld;
            PlatformEvent event = eventsTheyNeed.get(index);
            if (event.getCreatorId().equals((Object)selfId)) {
                needsToBeAtLeastThatOld = selfFilterThreshold;
                alwaysRecurse = true;
            } else if (parentHashesOfEventsToSend.contains(event.getHash())) {
                needsToBeAtLeastThatOld = ancestorFilterThreshold;
                alwaysRecurse = true;
            } else {
                needsToBeAtLeastThatOld = nonAncestorThreshold;
                alwaysRecurse = false;
            }
            boolean sendEvent = SyncUtils.haveWeKnownAboutEventForALongTime(event, needsToBeAtLeastThatOld, now);
            if (sendEvent) {
                filteredList.addFirst(event);
            }
            if (!sendEvent && !alwaysRecurse) continue;
            for (EventDescriptorWrapper otherParent : event.getAllParents()) {
                parentHashesOfEventsToSend.add(otherParent.hash());
            }
        }
        return filteredList.stream().toList();
    }

    private static boolean haveWeKnownAboutEventForALongTime(@NonNull PlatformEvent event, @NonNull Duration nonAncestorThreshold, @NonNull Instant now) {
        Instant eventReceivedTime = event.getTimeReceived();
        Duration timeKnown = Duration.between(eventReceivedTime, now);
        return CompareTo.isGreaterThan((Comparable)timeKnown, (Object)nonAncestorThreshold);
    }

    @NonNull
    public static Predicate<ShadowEvent> unknownNonAncient(@NonNull Collection<ShadowEvent> knownShadows, @NonNull EventWindow myEventWindow, @NonNull EventWindow theirEventWindow) {
        long minimumSearchThreshold = Math.max(myEventWindow.expiredThreshold(), theirEventWindow.ancientThreshold());
        return s -> s.getPlatformEvent().getBirthRound() >= minimumSearchThreshold && !knownShadows.contains(s);
    }

    public static int computeMultiTipCount(Iterable<ShadowEvent> tips) {
        HashMap<NodeId, Integer> tipCountByCreator = new HashMap<NodeId, Integer>();
        for (ShadowEvent tip : tips) {
            tipCountByCreator.compute(tip.getPlatformEvent().getCreatorId(), (k, v) -> v != null ? v + 1 : 1);
        }
        int creatorsWithBranches = 0;
        for (Map.Entry entry : tipCountByCreator.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            ++creatorsWithBranches;
        }
        return creatorsWithBranches;
    }

    static void sort(@NonNull List<PlatformEvent> sendList) {
        sendList.sort(Comparator.comparingLong(PlatformEvent::getNGen));
    }

    @NonNull
    static List<Boolean> getTheirTipsIHave(@NonNull List<ShadowEvent> theirTipShadows) {
        ArrayList<Boolean> myBooleans = new ArrayList<Boolean>(theirTipShadows.size());
        for (ShadowEvent s : theirTipShadows) {
            myBooleans.add(s != null);
        }
        return myBooleans;
    }

    @NonNull
    static List<ShadowEvent> getMyTipsTheyKnow(@NonNull Connection connection, @NonNull List<ShadowEvent> myTips, @NonNull List<Boolean> myTipsTheyHave) throws SyncException {
        Objects.requireNonNull(connection);
        if (myTipsTheyHave.size() != myTips.size()) {
            throw new SyncException(connection, String.format("peer booleans list is wrong size. Expected: %d Actual: %d,", myTips.size(), myTipsTheyHave.size()));
        }
        return SyncUtils.getMyTipsTheyKnow(myTips, myTipsTheyHave);
    }

    @NonNull
    static List<ShadowEvent> getMyTipsTheyKnow(@NonNull NodeId peerId, @NonNull List<ShadowEvent> myTips, @NonNull List<Boolean> myTipsTheyHave) {
        Objects.requireNonNull(peerId);
        if (myTipsTheyHave.size() != myTips.size()) {
            throw new RuntimeException(String.format("during sync with %s, peer booleans list is wrong size. Expected: %d Actual: %d,", peerId, myTips.size(), myTipsTheyHave.size()));
        }
        return SyncUtils.getMyTipsTheyKnow(myTips, myTipsTheyHave);
    }

    @NonNull
    private static List<ShadowEvent> getMyTipsTheyKnow(@NonNull List<ShadowEvent> myTips, @NonNull List<Boolean> myTipsTheyHave) {
        ArrayList<ShadowEvent> knownTips = new ArrayList<ShadowEvent>();
        for (int i = 0; i < myTipsTheyHave.size(); ++i) {
            if (!Boolean.TRUE.equals(myTipsTheyHave.get(i))) continue;
            knownTips.add(myTips.get(i));
        }
        return knownTips;
    }

    public static void serializeEventWindow(@NonNull SerializableDataOutputStream out, @NonNull EventWindow eventWindow) throws IOException {
        out.writeLong(eventWindow.latestConsensusRound());
        out.writeLong(eventWindow.ancientThreshold());
        out.writeLong(eventWindow.expiredThreshold());
    }

    @NonNull
    public static EventWindow deserializeEventWindow(@NonNull SerializableDataInputStream in) throws IOException {
        long latestConsensusRound = in.readLong();
        long ancientThreshold = in.readLong();
        long expiredThreshold = in.readLong();
        return new EventWindow(latestConsensusRound, latestConsensusRound + 1L, ancientThreshold, expiredThreshold);
    }

    public record TipsInfo(boolean dontSentEvents, @NonNull List<Boolean> theirTips) {
    }
}

