/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.protocol.rpc;

import com.swirlds.base.time.Time;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.consensus.gossip.config.BroadcastConfig;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncMetrics;

public class RpcOverloadMonitor {
    private static final long ENABLED = -1L;
    private final BroadcastConfig broadcastConfig;
    private final SyncMetrics syncMetrics;
    private final Time time;
    private final Consumer<Boolean> communicationOverloadHandler;
    private volatile long disabledBroadcastDueToQueueSizeTime = -1L;
    private volatile long disabledBroadcastDueToLagTime = -1L;

    public RpcOverloadMonitor(@NonNull BroadcastConfig syncConfig, @NonNull SyncMetrics syncMetrics, @NonNull Time time, @NonNull Consumer<Boolean> communicationOverloadHandler) {
        this.broadcastConfig = Objects.requireNonNull(syncConfig);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        this.time = Objects.requireNonNull(time);
        this.communicationOverloadHandler = Objects.requireNonNull(communicationOverloadHandler);
    }

    public void reportOutputQueueSize(int size) {
        if (size > this.broadcastConfig.throttleOutputQueueThreshold()) {
            if (this.disabledBroadcastDueToQueueSizeTime == -1L) {
                this.syncMetrics.disabledBroadcastDueToOverload(true);
                this.communicationOverloadHandler.accept(true);
            }
            this.disabledBroadcastDueToQueueSizeTime = this.time.currentTimeMillis();
        } else if (this.disabledBroadcastDueToQueueSizeTime != -1L && this.enoughTimePassedAfterDisable(this.disabledBroadcastDueToQueueSizeTime)) {
            this.disabledBroadcastDueToQueueSizeTime = -1L;
            this.syncMetrics.disabledBroadcastDueToOverload(false);
            if (this.disabledBroadcastDueToLagTime == -1L) {
                this.communicationOverloadHandler.accept(false);
            }
        }
    }

    public void reportPing(long pingMillis) {
        if (pingMillis > this.broadcastConfig.disablePingThreshold().toMillis()) {
            if (this.disabledBroadcastDueToLagTime == -1L) {
                this.syncMetrics.disabledBroadcastDueToLag(true);
                this.communicationOverloadHandler.accept(true);
            }
            this.disabledBroadcastDueToLagTime = this.time.currentTimeMillis();
        } else if (this.disabledBroadcastDueToLagTime != -1L && this.enoughTimePassedAfterDisable(this.disabledBroadcastDueToLagTime)) {
            this.disabledBroadcastDueToLagTime = -1L;
            this.syncMetrics.disabledBroadcastDueToLag(false);
            if (this.disabledBroadcastDueToQueueSizeTime == -1L) {
                this.communicationOverloadHandler.accept(false);
            }
        }
    }

    private boolean enoughTimePassedAfterDisable(long disableTime) {
        return this.time.currentTimeMillis() - disableTime > this.broadcastConfig.pauseOnLag().toMillis();
    }
}

