/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.impl;

import com.hedera.node.app.hints.HintsLibrary;
import com.hedera.node.app.hints.impl.HintsKeyAccessor;
import com.hedera.node.app.tss.SequentialContentManager;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HintsKeyAccessorImpl
implements HintsKeyAccessor,
SequentialContentManager.ContentReader<Bytes>,
SequentialContentManager.ContentWriter<Bytes> {
    private static final String SUB_DIRECTORY = "hints";
    private static final String FILE_CONTENT = "hinTS private key";
    private static final String FILE_NAME = "bls.bin";
    private final HintsLibrary library;
    private volatile SequentialContentManager<Bytes> contentManager;
    private final Supplier<Configuration> config;
    private final Map<Long, Bytes> privateKeys = new ConcurrentHashMap<Long, Bytes>();

    @Inject
    public HintsKeyAccessorImpl(@NonNull HintsLibrary library, Supplier<Configuration> config) {
        this.library = Objects.requireNonNull(library);
        this.config = config;
    }

    @Override
    public Bytes signWithBlsPrivateKey(long constructionId, @NonNull Bytes message) {
        Bytes key = this.getOrCreateBlsPrivateKey(constructionId);
        return this.library.signBls(message, key);
    }

    @Override
    public Bytes getOrCreateBlsPrivateKey(long constructionId) {
        return this.privateKeys.computeIfAbsent(constructionId, this.contentManager()::getOrCreateContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private SequentialContentManager<Bytes> contentManager() {
        if (this.contentManager == null) {
            HintsKeyAccessorImpl hintsKeyAccessorImpl = this;
            synchronized (hintsKeyAccessorImpl) {
                if (this.contentManager == null) {
                    Path pathToKeys = FileUtils.getAbsolutePath((String)((TssConfig)this.config.get().getConfigData(TssConfig.class)).tssKeysPath()).resolve(SUB_DIRECTORY);
                    this.contentManager = new SequentialContentManager<Bytes>(pathToKeys, FILE_CONTENT, FILE_NAME, this.library::newBlsPrivateKey, this, this);
                }
            }
        }
        return this.contentManager;
    }

    @Override
    @NonNull
    public Bytes readContent(@NonNull Path p) throws IOException {
        return Bytes.wrap((byte[])Files.readAllBytes(p));
    }

    @Override
    public void writeContent(@NonNull Bytes content, @NonNull Path p) throws IOException {
        Files.write(p, content.toByteArray(), new OpenOption[0]);
    }
}

