/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.history.ChainOfTrustProof;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.handlers.HistoryHandlers;
import com.hedera.node.app.history.impl.DaggerHistoryServiceComponent;
import com.hedera.node.app.history.impl.HistoryServiceComponent;
import com.hedera.node.app.history.impl.OnProofFinished;
import com.hedera.node.app.history.impl.ProofController;
import com.hedera.node.app.history.schemas.V071HistorySchema;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.Executor;

public class HistoryServiceImpl
implements HistoryService {
    private final HistoryServiceComponent component;
    @Nullable
    private HistoryProof historyProof;
    @Nullable
    private OnProofFinished cb;

    public HistoryServiceImpl(@NonNull Metrics metrics, @NonNull Executor executor, @NonNull AppContext appContext, @NonNull HistoryLibrary library) {
        this.component = DaggerHistoryServiceComponent.factory().create(library, appContext, executor, metrics, this);
    }

    @VisibleForTesting
    public HistoryServiceImpl(@NonNull HistoryServiceComponent component) {
        this.component = Objects.requireNonNull(component);
    }

    @Override
    public HistoryHandlers handlers() {
        return this.component.handlers();
    }

    @Override
    public Bytes historyProofVerificationKey() {
        return Bytes.wrap((byte[])this.component.library().wrapsVerificationKey());
    }

    @Override
    public void reconcile(@NonNull ActiveRosters activeRosters, @Nullable Bytes metadata, @NonNull WritableHistoryStore historyStore, @NonNull Instant now, @NonNull TssConfig tssConfig, boolean isActive, @Nullable HintsConstruction activeHintsConstruction) {
        Objects.requireNonNull(activeRosters);
        Objects.requireNonNull(historyStore);
        Objects.requireNonNull(now);
        Objects.requireNonNull(tssConfig);
        switch (activeRosters.phase()) {
            case BOOTSTRAP: 
            case TRANSITION: {
                HistoryProofConstruction construction = historyStore.getOrCreateConstruction(activeRosters, now, tssConfig);
                if (HistoryService.isCompleted(construction, tssConfig)) break;
                ProofController controller = this.component.controllers().getOrCreateFor(activeRosters, construction, historyStore, activeHintsConstruction, historyStore.getActiveConstruction(), tssConfig);
                controller.advanceConstruction(now, metadata, historyStore, isActive, tssConfig);
                break;
            }
        }
    }

    @Override
    public void onFinishedConstruction(@Nullable OnProofFinished cb) {
        this.cb = cb;
    }

    @Override
    public void onFinished(@NonNull WritableHistoryStore historyStore, @NonNull HistoryProofConstruction construction, @NonNull SortedMap<Long, Long> targetNodeWeights) {
        Objects.requireNonNull(historyStore);
        Objects.requireNonNull(construction);
        Objects.requireNonNull(targetNodeWeights);
        if (this.cb != null) {
            this.cb.onFinished(historyStore, construction, targetNodeWeights);
        }
    }

    @Override
    public void setLatestHistoryProof(@NonNull HistoryProof historyProof) {
        this.historyProof = Objects.requireNonNull(historyProof);
    }

    @Override
    public boolean isReady() {
        return this.historyProof != null && this.historyProof.hasChainOfTrustProof();
    }

    @Override
    @NonNull
    public ChainOfTrustProof getCurrentChainOfTrustProof(@NonNull Bytes metadata) {
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(this.historyProof);
        Bytes targetMetadata = this.historyProof.targetHistoryOrThrow().metadata();
        if (!targetMetadata.equals((Object)metadata)) {
            throw new IllegalArgumentException("Metadata '" + String.valueOf(metadata) + "' does not match proof (for '" + String.valueOf(targetMetadata) + "')");
        }
        return this.historyProof.chainOfTrustProofOrThrow();
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        Objects.requireNonNull(registry);
        registry.register((Schema)new V071HistorySchema(this));
    }

    public boolean doGenesisSetup(@NonNull WritableStates writableStates, @NonNull Configuration configuration) {
        Objects.requireNonNull(writableStates);
        Objects.requireNonNull(configuration);
        writableStates.getSingleton(V071HistorySchema.LEDGER_ID_STATE_ID).put((Object)ProtoBytes.DEFAULT);
        writableStates.getSingleton(V071HistorySchema.ACTIVE_PROOF_CONSTRUCTION_STATE_ID).put((Object)HistoryProofConstruction.DEFAULT);
        writableStates.getSingleton(V071HistorySchema.NEXT_PROOF_CONSTRUCTION_STATE_ID).put((Object)HistoryProofConstruction.DEFAULT);
        return true;
    }
}

