/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records;

import com.hedera.node.app.quiescence.QuiescedHeartbeat;
import com.hedera.node.app.quiescence.QuiescenceController;
import com.hedera.node.app.records.BlockRecordManager;
import com.hedera.node.app.records.impl.BlockRecordManagerImpl;
import com.hedera.node.app.records.impl.BlockRecordStreamProducer;
import com.hedera.node.app.records.impl.producers.BlockRecordFormat;
import com.hedera.node.app.records.impl.producers.BlockRecordWriterFactory;
import com.hedera.node.app.records.impl.producers.StreamFileProducerConcurrent;
import com.hedera.node.app.records.impl.producers.StreamFileProducerSingleThreaded;
import com.hedera.node.app.records.impl.producers.formats.BlockRecordWriterFactoryImpl;
import com.hedera.node.app.records.impl.producers.formats.v6.BlockRecordFormatV6;
import com.hedera.node.app.records.impl.producers.formats.v7.BlockRecordFormatV7;
import com.hedera.node.app.state.WorkingStateAccessor;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.BlockRecordStreamConfig;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.state.State;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import javax.inject.Singleton;

@Module
public abstract class BlockRecordInjectionModule {
    protected BlockRecordInjectionModule() {
    }

    @Provides
    @Singleton
    static FileSystem provideFileSystem() {
        return FileSystems.getDefault();
    }

    @Provides
    @Singleton
    public static BlockRecordStreamProducer provideStreamFileProducer(@NonNull ConfigProvider configProvider, @NonNull StreamFileProducerConcurrent concurrent, @NonNull StreamFileProducerSingleThreaded serial) {
        String producerType;
        BlockRecordStreamConfig recordStreamConfig = (BlockRecordStreamConfig)configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class);
        return switch (producerType = recordStreamConfig.streamFileProducer().toUpperCase()) {
            case "CONCURRENT" -> concurrent;
            case "SERIAL" -> serial;
            default -> throw new IllegalArgumentException("Unknown stream file producer type: " + producerType);
        };
    }

    @Provides
    @Singleton
    public static BlockRecordManager provideBlockRecordManager(@NonNull InitTrigger initTrigger, @NonNull ConfigProvider configProvider, @NonNull WorkingStateAccessor state, @NonNull BlockRecordStreamProducer streamFileProducer, @NonNull QuiescenceController quiescenceController, @NonNull QuiescedHeartbeat quiescedHeartbeat, @NonNull Platform platform) {
        State merkleState = state.getState();
        if (merkleState == null) {
            throw new IllegalStateException("Merkle state is null");
        }
        return new BlockRecordManagerImpl(configProvider, merkleState, streamFileProducer, quiescenceController, quiescedHeartbeat, platform, initTrigger);
    }

    @Provides
    @Singleton
    public static BlockRecordFormat provideBlockRecordFormat(@NonNull ConfigProvider configProvider) {
        BlockRecordStreamConfig recordStreamConfig = (BlockRecordStreamConfig)configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class);
        int recordFileVersion = recordStreamConfig.recordFileVersion();
        return switch (recordFileVersion) {
            case 6 -> BlockRecordFormatV6.INSTANCE;
            case 7 -> BlockRecordFormatV7.INSTANCE;
            default -> throw new IllegalArgumentException("Unknown block record version: " + recordFileVersion);
        };
    }

    @Binds
    @Singleton
    public abstract BlockRecordWriterFactory provideBlockRecordWriterFactory(@NonNull BlockRecordWriterFactoryImpl var1);
}

