/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap;

import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class VirtualMapIterator
implements Iterator<VirtualLeafBytes> {
    private final VirtualMap map;
    private final long firstPath;
    private final long lastPath;
    private long nextPath;
    private long previousPath = -1L;
    private VirtualLeafBytes<?> nextNode;
    private BiPredicate<VirtualLeafBytes, Long> filter;

    public VirtualMapIterator(@NonNull VirtualMap map) {
        this.map = Objects.requireNonNull(map);
        VirtualMapMetadata metadata = map.getMetadata();
        this.firstPath = metadata.getFirstLeafPath();
        this.lastPath = metadata.getLastLeafPath();
        this.nextPath = this.firstPath;
    }

    @NonNull
    public VirtualMapIterator setFilter(@Nullable Predicate<VirtualLeafBytes> filter) {
        if (this.nextNode != null || this.previousPath != -1L || this.nextPath != this.firstPath) {
            throw new IllegalStateException("Cannot set filter after iteration has started");
        }
        this.filter = filter == null ? null : (node, path) -> filter.test((VirtualLeafBytes)node);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextNode != null) {
            return true;
        }
        if (this.nextPath == -1L) {
            return false;
        }
        while (this.nextPath <= this.lastPath) {
            long path;
            ++this.nextPath;
            VirtualLeafBytes leaf = this.map.getRecords().findLeafRecord(path);
            assert (leaf != null);
            if (this.filter != null && !this.filter.test(leaf, path)) continue;
            this.nextNode = leaf;
            return true;
        }
        return false;
    }

    @Override
    public VirtualLeafBytes next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        VirtualLeafBytes<?> result = this.nextNode;
        this.nextNode = null;
        this.previousPath = result.path();
        return result;
    }

    @Nullable
    public Long getPath() {
        if (this.previousPath == -1L) {
            return null;
        }
        return this.previousPath;
    }
}

