/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.eventhandling;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.state.signed.ReservedSignedState;

public record StateWithHashComplexity(@NonNull ReservedSignedState reservedSignedState, long hashComplexity) {
    public StateWithHashComplexity {
        Objects.requireNonNull(reservedSignedState, "reservedSignedState cannot be null");
        if (hashComplexity < 1L) {
            throw new IllegalArgumentException("Hash complexity must be at least 1");
        }
    }

    @NonNull
    public StateWithHashComplexity makeAdditionalReservation(@NonNull String reservationReason) {
        return new StateWithHashComplexity(this.reservedSignedState.getAndReserve(reservationReason), this.hashComplexity);
    }
}

