/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces.impl;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.input.NoInput;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.io.RecycleBin;
import org.hiero.consensus.metrics.statistics.EventPipelineTracker;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.pces.PcesModule;
import org.hiero.consensus.pces.config.PcesConfig;
import org.hiero.consensus.pces.config.PcesWiringConfig;
import org.hiero.consensus.pces.impl.common.PcesFileManager;
import org.hiero.consensus.pces.impl.common.PcesFileReader;
import org.hiero.consensus.pces.impl.common.PcesFileTracker;
import org.hiero.consensus.pces.impl.common.PcesUtilities;
import org.hiero.consensus.pces.impl.copy.BestEffortPcesFileCopy;
import org.hiero.consensus.pces.impl.writer.DefaultInlinePcesWriter;
import org.hiero.consensus.pces.impl.writer.InlinePcesWriter;

public class DefaultPcesModule
implements PcesModule {
    @Nullable
    private ComponentWiring<InlinePcesWriter, PlatformEvent> pcesWriterWiring;
    @Nullable
    private PcesFileTracker initialPcesFiles;

    public void initialize(@NonNull WiringModel model, @NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull NodeId selfId, @NonNull RecycleBin recycleBin, long startingRound, @Nullable EventPipelineTracker pipelineTracker) {
        if (this.pcesWriterWiring != null) {
            throw new IllegalStateException("Already initialized");
        }
        PcesWiringConfig wiringConfig = (PcesWiringConfig)configuration.getConfigData(PcesWiringConfig.class);
        this.pcesWriterWiring = new ComponentWiring(model, InlinePcesWriter.class, wiringConfig.pcesInlineWriter());
        if (pipelineTracker != null) {
            pipelineTracker.registerMetric("pces");
            this.pcesWriterWiring.getOutputWire().solderForMonitoring(platformEvent -> pipelineTracker.recordEvent("pces", platformEvent.getTimeReceived()));
        }
        this.pcesWriterWiring.getInputWire(InlinePcesWriter::registerDiscontinuity);
        try {
            Path databaseDirectory = PcesUtilities.getDatabaseDirectory(configuration, selfId);
            boolean permitGaps = ((PcesConfig)configuration.getConfigData(PcesConfig.class)).permitGaps();
            this.initialPcesFiles = PcesFileReader.readFilesFromDisk(configuration, recycleBin, databaseDirectory, startingRound, permitGaps);
            PcesFileManager fileManager = new PcesFileManager(configuration, metrics, time, this.initialPcesFiles, databaseDirectory, startingRound);
            DefaultInlinePcesWriter pcesWriter = new DefaultInlinePcesWriter(configuration, metrics, time, fileManager, selfId);
            this.pcesWriterWiring.bind((Object)pcesWriter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NonNull
    public OutputWire<PlatformEvent> writtenEventsOutputWire() {
        return Objects.requireNonNull(this.pcesWriterWiring, "Not initialized").getOutputWire();
    }

    @NonNull
    public InputWire<PlatformEvent> eventsToWriteInputWire() {
        return Objects.requireNonNull(this.pcesWriterWiring, "Not initialized").getInputWire(InlinePcesWriter::writeEvent);
    }

    @NonNull
    public InputWire<EventWindow> eventWindowInputWire() {
        return Objects.requireNonNull(this.pcesWriterWiring, "Not initialized").getInputWire(InlinePcesWriter::updateNonAncientEventBoundary);
    }

    @NonNull
    public InputWire<Long> minimumAncientIdentifierInputWire() {
        return Objects.requireNonNull(this.pcesWriterWiring, "Not initialized").getInputWire(InlinePcesWriter::setMinimumAncientIdentifierToStore);
    }

    @NonNull
    public InputWire<NoInput> beginStreamingnewEventsInputWire() {
        return Objects.requireNonNull(this.pcesWriterWiring, "Not initialized").getInputWire(InlinePcesWriter::beginStreamingNewEvents);
    }

    @NonNull
    public InputWire<Long> discontinuityInputWire() {
        return Objects.requireNonNull(this.pcesWriterWiring, "Not initialized").getInputWire(InlinePcesWriter::registerDiscontinuity);
    }

    @NonNull
    public IOIterator<PlatformEvent> storedEvents(long pcesReplayLowerBound, long startingRound) {
        return Objects.requireNonNull(this.initialPcesFiles, "Not initialized").getEventIterator(pcesReplayLowerBound, startingRound);
    }

    public void flush() {
        Objects.requireNonNull(this.pcesWriterWiring, "Not initialized").flush();
    }

    public void copyPcesFilesRetryOnFailure(@NonNull Configuration configuration, @NonNull NodeId selfId, @NonNull Path destinationDirectory, long lowerBound, long round) {
        BestEffortPcesFileCopy.copyPcesFilesRetryOnFailure(configuration, selfId, destinationDirectory, lowerBound, round);
    }
}

