/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.codec;

import com.hedera.hapi.block.stream.MerklePath;
import com.hedera.hapi.block.stream.SiblingNode;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MerklePathJsonCodec
implements JsonCodec<MerklePath> {
    public static final OneOf<MerklePath.ContentOneOfType> CONTENT_UNSET = new OneOf((Enum)MerklePath.ContentOneOfType.UNSET, null);

    @NonNull
    public MerklePath parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            List temp_siblings = Collections.emptyList();
            int temp_next_path_index = 0;
            OneOf temp_content = CONTENT_UNSET;
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "siblings": {
                        temp_siblings = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"siblings", (List)kvPair.value().arr().value(), (int)maxSize), SiblingNode.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block18;
                    }
                    case "nextPathIndex": {
                        temp_next_path_index = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "hash": {
                        temp_content = new OneOf((Enum)MerklePath.ContentOneOfType.HASH, (Object)Bytes.fromBase64((String)JsonTools.checkSize((String)"hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE))));
                        continue block18;
                    }
                    case "stateItemLeaf": {
                        temp_content = new OneOf((Enum)MerklePath.ContentOneOfType.STATE_ITEM_LEAF, (Object)Bytes.fromBase64((String)JsonTools.checkSize((String)"state_item_leaf", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE))));
                        continue block18;
                    }
                    case "blockItemLeaf": {
                        temp_content = new OneOf((Enum)MerklePath.ContentOneOfType.BLOCK_ITEM_LEAF, (Object)Bytes.fromBase64((String)JsonTools.checkSize((String)"block_item_leaf", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE))));
                        continue block18;
                    }
                    case "timestampLeaf": {
                        temp_content = new OneOf((Enum)MerklePath.ContentOneOfType.TIMESTAMP_LEAF, (Object)Bytes.fromBase64((String)JsonTools.checkSize((String)"timestamp_leaf", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE))));
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new MerklePath(temp_siblings, temp_next_path_index, temp_content);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull MerklePath data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (!data.siblings().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"siblings", SiblingNode.JSON, data.siblings()));
        }
        if (data.nextPathIndex() != 0) {
            fieldLines.add(JsonTools.field((String)"nextPathIndex", (int)data.nextPathIndex()));
        }
        if (data.content().kind() == MerklePath.ContentOneOfType.HASH) {
            fieldLines.add(JsonTools.field((String)"hash", (Bytes)data.hash()));
        }
        if (data.content().kind() == MerklePath.ContentOneOfType.STATE_ITEM_LEAF) {
            fieldLines.add(JsonTools.field((String)"stateItemLeaf", (Bytes)data.stateItemLeaf()));
        }
        if (data.content().kind() == MerklePath.ContentOneOfType.BLOCK_ITEM_LEAF) {
            fieldLines.add(JsonTools.field((String)"blockItemLeaf", (Bytes)data.blockItemLeaf()));
        }
        if (data.content().kind() == MerklePath.ContentOneOfType.TIMESTAMP_LEAF) {
            fieldLines.add(JsonTools.field((String)"timestampLeaf", (Bytes)data.timestampLeaf()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

