/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.exceptions;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.SocketException;

public final class ThrowableUtilities {
    private ThrowableUtilities() {
    }

    public static boolean isOrCausedBySocketException(@Nullable Throwable ex) {
        return ThrowableUtilities.isRootCauseSuppliedType(ex, SocketException.class);
    }

    public static boolean isCausedByIOException(@Nullable Exception e) {
        return ThrowableUtilities.isRootCauseSuppliedType(e, IOException.class);
    }

    public static boolean isRootCauseSuppliedType(@Nullable Throwable t, @NonNull Class<? extends Throwable> type) {
        if (t == null) {
            return false;
        }
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return type.isInstance(cause);
    }

    public static boolean hasAnyCauseSuppliedType(@NonNull Throwable throwable, @NonNull Class<? extends Throwable> type) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!type.isInstance(cause)) continue;
            return true;
        }
        return false;
    }
}

