/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.builder.internal;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.startup.Log4jSetup;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.NodeStartPayload;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.CryptoMetrics;
import com.swirlds.platform.util.BootstrapUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.metrics.platform.DefaultMetricsProvider;

public final class StaticPlatformBuilder {
    private static final Logger logger = LogManager.getLogger(StaticPlatformBuilder.class);
    public static final String STARTUP_MESSAGE = "  //////////////////////\n // Node is Starting //\n//////////////////////";
    private static boolean staticSetupCompleted = false;
    private static DefaultMetricsProvider metricsProvider;
    private static Metrics globalMetrics;

    private StaticPlatformBuilder() {
    }

    public static void initLogging() {
        Path log4jPath = FileUtils.getAbsolutePath((String)"log4j2.xml");
        try {
            Log4jSetup.startLoggingFramework((Path)log4jPath).await();
            logger.info(LogMarker.STARTUP.getMarker(), "\n\n  //////////////////////\n // Node is Starting //\n//////////////////////\n");
            logger.debug(LogMarker.STARTUP.getMarker(), () -> new NodeStartPayload().toString());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for log4j to initialize", e);
        }
    }

    public static void setupGlobalMetrics(@NonNull Configuration configuration) {
        if (metricsProvider == null) {
            metricsProvider = new DefaultMetricsProvider(configuration);
            globalMetrics = metricsProvider.createGlobalMetrics();
            CryptoMetrics.registerMetrics(globalMetrics);
        }
    }

    public static boolean doStaticSetup(@NonNull Configuration configuration, @NonNull Path settingsPath) {
        if (staticSetupCompleted) {
            return false;
        }
        staticSetupCompleted = true;
        BootstrapUtils.performHealthChecks(settingsPath, configuration);
        BootstrapUtils.writeSettingsUsed(configuration);
        BootstrapUtils.startJVMPauseDetectorThread(configuration);
        return true;
    }

    @NonNull
    public static DefaultMetricsProvider getMetricsProvider() {
        if (metricsProvider == null) {
            throw new IllegalStateException("Metrics provider has not been initialized");
        }
        return metricsProvider;
    }

    @NonNull
    public static Metrics getGlobalMetrics() {
        if (globalMetrics == null) {
            throw new IllegalStateException("Global metrics have not been initialized");
        }
        return globalMetrics;
    }
}

