/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.crypto;

import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.crypto.EnhancedKeyStoreLoader;
import com.swirlds.platform.crypto.KeyLoadingException;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.config.BasicConfig;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.crypto.KeyGeneratingException;
import org.hiero.consensus.crypto.KeysAndCertsGenerator;
import org.hiero.consensus.exceptions.ThrowableUtilities;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public final class CryptoStatic {
    private static final Logger logger = LogManager.getLogger(CryptoStatic.class);
    private static final String LOCAL_NODES_MUST_NOT_BE_NULL = "the local nodes must not be null";

    private CryptoStatic() {
    }

    @NonNull
    public static KeyStore loadKeys(@NonNull Path file, @NonNull char[] password) throws KeyStoreException, KeyLoadingException {
        KeyStore store = ConsensusCryptoUtils.createEmptyTrustStore();
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            store.load(fis, password);
            if (store.size() == 0) {
                throw new KeyLoadingException("there are no valid keys or certificates in " + String.valueOf(file));
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyLoadingException("there was a problem reading: " + String.valueOf(file), e);
        }
        return store;
    }

    @NonNull
    public static Map<NodeId, KeysAndCerts> generateKeysAndCerts(@NonNull Collection<NodeId> nodeIds) throws ExecutionException, InterruptedException, KeyStoreException {
        HashMap futures = HashMap.newHashMap(nodeIds.size());
        try (ExecutorService threadPool = Executors.newCachedThreadPool(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("browser")).setThreadName("crypto-generate")).setDaemon(false)).buildFactory());){
            for (NodeId nodeId : nodeIds) {
                futures.put(nodeId, threadPool.submit(() -> KeysAndCertsGenerator.generate((NodeId)nodeId)));
            }
            Map<NodeId, KeysAndCerts> keysAndCerts = CryptoStatic.futuresToMap(futures);
            threadPool.shutdown();
            Map<NodeId, KeysAndCerts> map = keysAndCerts;
            return map;
        }
    }

    @NonNull
    private static <T> Map<NodeId, T> futuresToMap(@NonNull Map<NodeId, Future<T>> futures) throws ExecutionException, InterruptedException {
        HashMap<NodeId, T> map = new HashMap<NodeId, T>();
        for (Map.Entry<NodeId, Future<T>> entry : futures.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    public static KeysAndCerts initNodeSecurity(@NonNull Configuration configuration, @NonNull NodeId localNode, @NonNull List<RosterEntry> rosterEntries) {
        Map<NodeId, KeysAndCerts> keysAndCerts;
        BasicConfig basicConfig;
        block11: {
            Objects.requireNonNull(configuration, "configuration must not be null");
            Objects.requireNonNull(localNode, LOCAL_NODES_MUST_NOT_BE_NULL);
            PathsConfig pathsConfig = (PathsConfig)configuration.getConfigData(PathsConfig.class);
            basicConfig = (BasicConfig)configuration.getConfigData(BasicConfig.class);
            try {
                if (basicConfig.loadKeysFromPfxFiles()) {
                    try (Stream<Path> list = Files.list(pathsConfig.getKeysDirPath());){
                        CommonUtils.tellUserConsole((String)("Reading crypto keys from the files here:   " + Arrays.toString(list.map(p -> p.getFileName().toString()).filter(fileName -> fileName.endsWith("pfx") || fileName.endsWith("pem")).toArray())));
                    }
                    logger.debug(LogMarker.STARTUP.getMarker(), "About to start loading keys");
                    logger.debug(LogMarker.STARTUP.getMarker(), "Reading keys using the enhanced key loader");
                    keysAndCerts = EnhancedKeyStoreLoader.using(configuration, Set.of(localNode), rosterEntries).migrate().scan().generate().verify().keysAndCerts();
                    logger.debug(LogMarker.STARTUP.getMarker(), "Done loading keys");
                    break block11;
                }
                CommonUtils.tellUserConsole((String)("Keys will be generated in: " + String.valueOf(pathsConfig.getKeysDirPath()) + ", which is incompatible with DAB."));
                logger.warn(LogMarker.STARTUP.getMarker(), "There are no keys on disk, Adhoc keys will be generated, but this is incompatible with DAB.");
                logger.debug(LogMarker.STARTUP.getMarker(), "Started generating keys");
                keysAndCerts = CryptoStatic.generateKeysAndCerts(Set.of(localNode));
                logger.debug(LogMarker.STARTUP.getMarker(), "Done generating keys");
            }
            catch (KeyLoadingException | IOException | InterruptedException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | ExecutionException | KeyGeneratingException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while loading/generating keys", e);
                if (ThrowableUtilities.isRootCauseSuppliedType((Throwable)e, NoSuchAlgorithmException.class) || ThrowableUtilities.isRootCauseSuppliedType((Throwable)e, NoSuchProviderException.class)) {
                    CommonUtils.tellUserConsolePopup((String)"ERROR", (String)"ERROR: This Java installation does not have the needed cryptography providers installed");
                }
                SystemExitUtils.exitSystem(SystemExitCode.KEY_LOADING_FAILED);
                throw new CryptographyException(e);
            }
        }
        String msg = basicConfig.loadKeysFromPfxFiles() ? "Certificate loaded: {}" : "Certificate generated: {}";
        keysAndCerts.forEach((nodeId, keysAndCertsForNode) -> {
            if (keysAndCertsForNode == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "No keys and certs for node {}", nodeId);
                return;
            }
            logger.debug(LogMarker.CERTIFICATES.getMarker(), "Node ID: {}", nodeId);
            logger.debug(LogMarker.CERTIFICATES.getMarker(), msg, (Object)keysAndCertsForNode.sigCert());
            logger.debug(LogMarker.CERTIFICATES.getMarker(), msg, (Object)keysAndCertsForNode.agrCert());
        });
        return keysAndCerts.get(localNode);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

