/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.swirlds.base.formatting.StringFormattingUtils;
import com.swirlds.common.merkle.synchronization.LearningSynchronizer;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapMetrics;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectDataUsagePayload;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.reconnect.ReconnectStateException;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hashable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.reconnect.config.ReconnectConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SigSet;
import org.hiero.consensus.state.signed.SignedState;
import org.hiero.consensus.state.signed.SignedStateInvalidException;

public class ReconnectStateLearner {
    private static final Logger logger = LogManager.getLogger(ReconnectStateLearner.class);
    private static final long END_RECONNECT_MSG = 8595038238444960609L;
    private final Connection connection;
    private final VirtualMapState currentState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics statistics;
    private final StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager;
    private final Configuration configuration;
    private final Metrics metrics;
    private SigSet sigSet;
    private int originalSocketTimeout;
    private final ThreadManager threadManager;

    public ReconnectStateLearner(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull ThreadManager threadManager, @NonNull Connection connection, @NonNull VirtualMapState currentState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics statistics, @NonNull StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager) {
        this.stateLifecycleManager = Objects.requireNonNull(stateLifecycleManager);
        currentState.throwIfImmutable("Can not perform reconnect with immutable state");
        currentState.throwIfDestroyed("Can not perform reconnect with destroyed state");
        this.configuration = Objects.requireNonNull(configuration);
        this.metrics = Objects.requireNonNull(metrics);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.connection = Objects.requireNonNull(connection);
        this.currentState = Objects.requireNonNull(currentState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.statistics = Objects.requireNonNull(statistics);
    }

    static void endReconnectHandshake(@NonNull Connection connection) throws IOException {
        connection.getDos().writeLong(8595038238444960609L);
        connection.getDos().flush();
        long endReconnectMsg = connection.getDis().readLong();
        if (endReconnectMsg != 8595038238444960609L) {
            throw new IOException("Did not receive expected end reconnect message. Expecting %x, Received %x".formatted(8595038238444960609L, endReconnectMsg));
        }
    }

    private void increaseSocketTimeout() throws ReconnectStateException {
        try {
            this.originalSocketTimeout = this.connection.getTimeout();
            this.connection.setTimeout(this.reconnectSocketTimeout.toMillis());
        }
        catch (SocketException e) {
            throw new ReconnectStateException(e);
        }
    }

    private void resetSocketTimeout() throws ReconnectStateException {
        if (!this.connection.connected()) {
            logger.debug(LogMarker.RECONNECT.getMarker(), "{} connection to {} is no longer connected. Returning.", (Object)this.connection.getSelfId(), (Object)this.connection.getOtherId());
            return;
        }
        try {
            this.connection.setTimeout((long)this.originalSocketTimeout);
        }
        catch (SocketException e) {
            throw new ReconnectStateException(e);
        }
    }

    @NonNull
    public ReservedSignedState execute() throws ReconnectStateException {
        this.increaseSocketTimeout();
        ReservedSignedState reservedSignedState = null;
        try {
            this.receiveSignatures();
            reservedSignedState = this.reconnect();
            ReconnectStateLearner.endReconnectHandshake(this.connection);
            ReservedSignedState reservedSignedState2 = reservedSignedState;
            return reservedSignedState2;
        }
        catch (ParseException | IOException | SignedStateInvalidException e) {
            if (reservedSignedState != null) {
                reservedSignedState.close();
            }
            throw new ReconnectStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReconnectStateException("interrupted while attempting to reconnect", e);
        }
        finally {
            this.resetSocketTimeout();
        }
    }

    @NonNull
    private ReservedSignedState reconnect() throws InterruptedException {
        this.statistics.incrementReceiverStartTimes();
        SerializableDataInputStream in = new SerializableDataInputStream((InputStream)this.connection.getDis());
        SerializableDataOutputStream out = new SerializableDataOutputStream((OutputStream)this.connection.getDos());
        this.connection.getDis().getSyncByteCounter().resetCount();
        this.connection.getDos().getSyncByteCounter().resetCount();
        ReconnectConfig reconnectConfig = (ReconnectConfig)this.configuration.getConfigData(ReconnectConfig.class);
        VirtualMap reconnectRoot = this.currentState.getRoot().newReconnectRoot();
        ReconnectMapMetrics mapStats = new ReconnectMapMetrics(this.metrics, null, null);
        LearnerTreeView learnerView = reconnectRoot.buildLearnerView(reconnectConfig, (ReconnectMapStats)mapStats);
        LearningSynchronizer synchronizer = new LearningSynchronizer(this.threadManager, in, out, (Hashable)reconnectRoot, learnerView, () -> ((Connection)this.connection).disconnect(), reconnectConfig);
        try {
            synchronizer.synchronize();
            logger.info(LogMarker.RECONNECT.getMarker(), () -> ((ReconnectMapStats)mapStats).format());
        }
        catch (InterruptedException e) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "Synchronization interrupted");
            Thread.currentThread().interrupt();
            reconnectRoot.release();
            throw e;
        }
        catch (Exception e) {
            reconnectRoot.release();
            throw new MerkleSynchronizationException(e);
        }
        VirtualMapState receivedState = (VirtualMapState)this.stateLifecycleManager.createStateFrom((Object)reconnectRoot);
        SignedState newSignedState = new SignedState(this.configuration, ConsensusCryptoUtils::verifySignature, receivedState, "ReconnectLearner.reconnect()", false, false, false);
        SignedStateFileReader.registerServiceStates(newSignedState);
        newSignedState.setSigSet(this.sigSet);
        double mbReceived = this.connection.getDis().getSyncByteCounter().getMebiBytes();
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectDataUsagePayload("Reconnect data usage report", mbReceived).toString());
        this.statistics.incrementReceiverEndTimes();
        return newSignedState.reserve("ReconnectLearner.reconnect()");
    }

    private void receiveSignatures() throws IOException, ParseException {
        logger.info(LogMarker.RECONNECT.getMarker(), "Receiving signed state signatures");
        this.sigSet = new SigSet();
        ReadableStreamingData streamingData = new ReadableStreamingData((InputStream)this.connection.getDis());
        this.sigSet.deserialize(streamingData);
        StringBuilder sb = new StringBuilder();
        sb.append("Received signatures from nodes ");
        StringFormattingUtils.formattedList((StringBuilder)sb, (Iterator)this.sigSet.iterator());
        logger.info(LogMarker.RECONNECT.getMarker(), (CharSequence)sb);
    }
}

