/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.signer;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.state.signer.StateSigner;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.state.signed.ReservedSignedState;

public class DefaultStateSigner
implements StateSigner {
    private final PlatformSigner signer;

    public DefaultStateSigner(@NonNull PlatformSigner signer) {
        this.signer = Objects.requireNonNull(signer);
    }

    @Override
    @Nullable
    public StateSignatureTransaction signState(@NonNull ReservedSignedState reservedSignedState) {
        try (ReservedSignedState reservedSignedState2 = reservedSignedState;){
            if (reservedSignedState.get().isPcesRound()) {
                StateSignatureTransaction stateSignatureTransaction = null;
                return stateSignatureTransaction;
            }
            Hash stateHash = Objects.requireNonNull(reservedSignedState.get().getState().getHash());
            Bytes signature = this.signer.sign(stateHash.getBytes());
            Objects.requireNonNull(signature);
            StateSignatureTransaction stateSignatureTransaction = StateSignatureTransaction.newBuilder().round(reservedSignedState.get().getRound()).signature(signature).hash(stateHash.getBytes()).build();
            return stateSignatureTransaction;
        }
    }
}

