/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.hasschedulecapacity;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.hasschedulecapacity.HasScheduleCapacityCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HasScheduleCapacityTranslator
extends AbstractCallTranslator<HssCallAttempt> {
    private static final int EXPIRY_INDEX = 0;
    private static final int GAS_LIMIT_INDEX = 1;
    public static final SystemContractMethod HAS_SCHEDULE_CAPACITY = SystemContractMethod.declare("hasScheduleCapacity(uint256,uint256)", "(bool)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.SCHEDULE);

    @Inject
    public HasScheduleCapacityTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HSS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(HAS_SCHEDULE_CAPACITY);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HssCallAttempt attempt) {
        if (((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractScheduleCallEnabled()) {
            return attempt.isMethod(HAS_SCHEDULE_CAPACITY);
        }
        return Optional.empty();
    }

    @Override
    public Call callFrom(@NonNull HssCallAttempt attempt) {
        Tuple call = HAS_SCHEDULE_CAPACITY.decodeCall(attempt.inputBytes());
        long expiry = ConversionUtils.asLongLimitedToZeroOrMax((BigInteger)call.get(0));
        long gasLimit = ConversionUtils.asLongLimitedToZeroOrMax((BigInteger)call.get(1));
        return new HasScheduleCapacityCall(attempt, expiry, gasLimit);
    }
}

