/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.AbstractGrantApprovalCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.GrantApprovalLoggingUtils;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.GrantApprovalTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ERCGrantApprovalCall
extends AbstractGrantApprovalCall {
    public ERCGrantApprovalCall(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull SystemContractGasCalculator gasCalculator, @NonNull VerificationStrategy verificationStrategy, @NonNull AccountID senderId, @NonNull TokenID tokenId, @NonNull AccountID spenderId, long amount, @NonNull TokenType tokenType) {
        super(gasCalculator, enhancement, verificationStrategy, senderId, tokenId, spenderId, amount, tokenType, false);
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        if (this.tokenId == null) {
            return this.reversionWith(ResponseCodeEnum.INVALID_TOKEN_ID, this.gasCalculator.canonicalGasRequirement(DispatchType.APPROVE));
        }
        TransactionBody body = this.synthApprovalBody();
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(body, this.verificationStrategy, this.senderId, ContractCallStreamBuilder.class);
        ResponseCodeEnum status = this.withMonoStandard(recordBuilder).status();
        long gasRequirement = this.gasCalculator.gasRequirement(body, DispatchType.APPROVE, this.senderId);
        if (status != ResponseCodeEnum.SUCCESS) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(recordBuilder, gasRequirement), status, false);
        }
        if (this.tokenType.equals((Object)TokenType.NON_FUNGIBLE_UNIQUE)) {
            GrantApprovalLoggingUtils.logSuccessfulNFTApprove(this.tokenId, this.senderId, this.spenderId, this.amount, this.readableAccountStore(), frame);
        } else {
            GrantApprovalLoggingUtils.logSuccessfulFTApprove(this.tokenId, this.senderId, this.spenderId, this.amount, this.readableAccountStore(), frame);
        }
        ByteBuffer encodedOutput = this.tokenType.equals((Object)TokenType.FUNGIBLE_COMMON) ? GrantApprovalTranslator.ERC_GRANT_APPROVAL.getOutputs().encode((Object)Tuple.singleton((Object)true)) : GrantApprovalTranslator.ERC_GRANT_APPROVAL_NFT.getOutputs().encode((Object)Tuple.EMPTY);
        return Call.PricedResult.gasOnly(FullResult.successResult(encodedOutput, gasRequirement, recordBuilder), status, false);
    }
}

