/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.wipe;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.token.TokenWipeAccountTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.wipe.WipeTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WipeDecoder {
    @Inject
    public WipeDecoder() {
    }

    public TransactionBody decodeWipeFungibleV1(@NonNull HtsCallAttempt attempt) {
        Tuple call = WipeTranslator.WIPE_FUNGIBLE_V1.decodeCall(attempt.inputBytes());
        return this.bodyOf(this.wipeFungible(attempt, (Address)call.get(0), (Address)call.get(1), (Long)call.get(2)));
    }

    public TransactionBody decodeWipeFungibleV2(@NonNull HtsCallAttempt attempt) {
        Tuple call = WipeTranslator.WIPE_FUNGIBLE_V2.decodeCall(attempt.inputBytes());
        return this.bodyOf(this.wipeFungible(attempt, (Address)call.get(0), (Address)call.get(1), (Long)call.get(2)));
    }

    public TransactionBody decodeWipeNonFungible(@NonNull HtsCallAttempt attempt) {
        Tuple call = WipeTranslator.WIPE_NFT.decodeCall(attempt.inputBytes());
        return this.bodyOf(this.wipeNonFungible(attempt, (Address)call.get(0), (Address)call.get(1), (long[])call.get(2)));
    }

    private TokenWipeAccountTransactionBody wipeFungible(@NonNull HtsCallAttempt attempt, @NonNull Address tokenAddress, @NonNull Address accountAddress, long amount) {
        return TokenWipeAccountTransactionBody.newBuilder().token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress)).account(attempt.addressIdConverter().convert(accountAddress)).amount(amount).build();
    }

    private TokenWipeAccountTransactionBody wipeNonFungible(@NonNull HtsCallAttempt attempt, @NonNull Address tokenAddress, @NonNull Address accountAddress, @NonNull long[] serialNumbers) {
        return TokenWipeAccountTransactionBody.newBuilder().token(ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), tokenAddress)).account(attempt.addressIdConverter().convert(accountAddress)).serialNumbers(Arrays.stream(serialNumbers).boxed().toList()).build();
    }

    private TransactionBody bodyOf(@NonNull TokenWipeAccountTransactionBody wipeAccountTransactionBody) {
        return TransactionBody.newBuilder().tokenWipe(wipeAccountTransactionBody).build();
    }
}

