/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.node.config.data.OpsDurationConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record OpsDurationSchedule(List<Long> opsDurationByOpCode, long opsGasBasedDurationMultiplier, long precompileGasBasedDurationMultiplier, long systemContractGasBasedDurationMultiplier, long accountLazyCreationOpsDurationMultiplier, long multipliersDenominator) {
    private static final OpsDurationSchedule EMPTY = new OpsDurationSchedule(Collections.nCopies(256, 0L), 0L, 0L, 0L, 0L, 1L);
    private static final long DEFAULT_MULTIPLIERS_DENOMINATOR = 100L;

    public static OpsDurationSchedule empty() {
        return EMPTY;
    }

    public static OpsDurationSchedule fromConfig(@NonNull OpsDurationConfig opsDurationConfig) {
        if (opsDurationConfig.opsDurationByOpCode().size() != 256) {
            throw new IllegalArgumentException("Invalid ops duration config: opsDurationByOpCode must contain exactly 256 elements, but it has " + opsDurationConfig.opsDurationByOpCode().size());
        }
        return new OpsDurationSchedule(opsDurationConfig.opsDurationByOpCode(), opsDurationConfig.opsGasBasedDurationMultiplier(), opsDurationConfig.precompileGasBasedDurationMultiplier(), opsDurationConfig.systemContractGasBasedDurationMultiplier(), opsDurationConfig.accountLazyCreationOpsDurationMultiplier(), 100L);
    }

    public long opCodeCost(int opCode) {
        return this.opsDurationByOpCode.get(opCode);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OpsDurationSchedule)) {
            return false;
        }
        OpsDurationSchedule that = (OpsDurationSchedule)o;
        return this.multipliersDenominator == that.multipliersDenominator && this.opsGasBasedDurationMultiplier == that.opsGasBasedDurationMultiplier && this.precompileGasBasedDurationMultiplier == that.precompileGasBasedDurationMultiplier && this.systemContractGasBasedDurationMultiplier == that.systemContractGasBasedDurationMultiplier && this.accountLazyCreationOpsDurationMultiplier == that.accountLazyCreationOpsDurationMultiplier && this.opsDurationByOpCode.equals(that.opsDurationByOpCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.opsDurationByOpCode, this.opsGasBasedDurationMultiplier, this.precompileGasBasedDurationMultiplier, this.systemContractGasBasedDurationMultiplier, this.accountLazyCreationOpsDurationMultiplier, this.multipliersDenominator);
    }
}

