/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class AddOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult addSuccess = new Operation.OperationResult(3L, null);

    public AddOperation(GasCalculator gasCalculator) {
        super(1, "ADD", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return AddOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        BigInteger value1;
        BigInteger value0 = new BigInteger(1, frame.popStackItem().toArrayUnsafe());
        BigInteger result = value0.add(value1 = new BigInteger(1, frame.popStackItem().toArrayUnsafe()));
        byte[] resultArray = result.toByteArray();
        int length = resultArray.length;
        if (length > 32) {
            frame.pushStackItem(Bytes.wrap((byte[])resultArray, (int)(length - 32), (int)32));
        } else {
            frame.pushStackItem(Bytes.wrap((byte[])resultArray));
        }
        return addSuccess;
    }
}

