/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import java.math.BigInteger;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.bytes.MutableBytes32;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.crypto.SECPPublicKey;
import org.hyperledger.besu.crypto.SECPSignature;
import org.hyperledger.besu.crypto.SignatureAlgorithm;
import org.hyperledger.besu.crypto.SignatureAlgorithmFactory;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class ECRECPrecompiledContract
extends AbstractPrecompiledContract {
    private static final int V_BASE = 27;
    final SignatureAlgorithm signatureAlgorithm;

    public ECRECPrecompiledContract(GasCalculator gasCalculator) {
        this(gasCalculator, SignatureAlgorithmFactory.getInstance());
    }

    public ECRECPrecompiledContract(GasCalculator gasCalculator, SignatureAlgorithm signatureAlgorithm) {
        super("ECREC", gasCalculator);
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public long gasRequirement(Bytes input) {
        return this.gasCalculator().getEcrecPrecompiledContractGasCost();
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        SECPSignature signature;
        int size = input.size();
        Bytes d = size >= 128 ? input : Bytes.wrap((Bytes[])new Bytes[]{input, MutableBytes.create((int)(128 - size))});
        Bytes32 h = Bytes32.wrap((Bytes)d, (int)0);
        if (!d.slice(32, 31).isZero()) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.EMPTY);
        }
        int recId = d.get(63) - 27;
        BigInteger r = d.slice(64, 32).toUnsignedBigInteger();
        BigInteger s = d.slice(96, 32).toUnsignedBigInteger();
        try {
            signature = this.signatureAlgorithm.createSignature(r, s, (byte)recId);
        }
        catch (IllegalArgumentException e) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.EMPTY);
        }
        try {
            Optional recovered = this.signatureAlgorithm.recoverPublicKeyFromSignature(h, signature);
            if (recovered.isEmpty()) {
                return PrecompiledContract.PrecompileContractResult.success(Bytes.EMPTY);
            }
            Bytes32 hashed = Hash.keccak256((Bytes)((SECPPublicKey)recovered.get()).getEncodedBytes());
            MutableBytes32 result = MutableBytes32.create();
            hashed.slice(12).copyTo((MutableBytes)result, 12);
            return PrecompiledContract.PrecompileContractResult.success((Bytes)result);
        }
        catch (IllegalArgumentException e) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.EMPTY);
        }
    }
}

