/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import org.hiero.consensus.metrics.PlatformMetricConfig;
import org.hiero.consensus.metrics.PlatformMetricsFactory;

public interface RunningAverageMetric
extends Metric {
    @NonNull
    default public MetricType getMetricType() {
        return MetricType.RUNNING_AVERAGE;
    }

    @NonNull
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @NonNull
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE, Metric.ValueType.MAX, Metric.ValueType.MIN, Metric.ValueType.STD_DEV);
    }

    @NonNull
    public Double get(@NonNull Metric.ValueType var1);

    public double getHalfLife();

    public void update(double var1);

    public double get();

    public static final class Config
    extends PlatformMetricConfig<RunningAverageMetric, Config> {
        private final double halfLife;
        private final boolean useDefaultHalfLife;

        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%,11.3f");
            this.halfLife = -1.0;
            this.useDefaultHalfLife = true;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, double halfLife, boolean useDefaultHalfLife) {
            super(category, name, description, unit, format);
            this.halfLife = halfLife;
            this.useDefaultHalfLife = useDefaultHalfLife;
        }

        @NonNull
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        @NonNull
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        @NonNull
        public Config withFormat(@NonNull String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getHalfLife(), this.isUseDefaultHalfLife());
        }

        public double getHalfLife() {
            return this.halfLife;
        }

        public boolean isUseDefaultHalfLife() {
            return this.useDefaultHalfLife;
        }

        @NonNull
        public Config withHalfLife(double halfLife) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), halfLife, false);
        }

        @NonNull
        public Class<RunningAverageMetric> getResultClass() {
            return RunningAverageMetric.class;
        }

        @Override
        @NonNull
        public RunningAverageMetric create(@NonNull PlatformMetricsFactory factory) {
            return factory.createRunningAverageMetric(this);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", (Object)this.halfLife).toString();
        }
    }
}

