/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform;

import com.swirlds.metrics.impl.DefaultMetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.metrics.DurationGauge;
import org.hiero.consensus.metrics.FunctionGauge;
import org.hiero.consensus.metrics.IntegerPairAccumulator;
import org.hiero.consensus.metrics.PlatformMetricsFactory;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.metrics.SpeedometerMetric;
import org.hiero.consensus.metrics.StatEntry;
import org.hiero.consensus.metrics.config.MetricsConfig;
import org.hiero.consensus.metrics.platform.PlatformDurationGauge;
import org.hiero.consensus.metrics.platform.PlatformFunctionGauge;
import org.hiero.consensus.metrics.platform.PlatformIntegerPairAccumulator;
import org.hiero.consensus.metrics.platform.PlatformRunningAverageMetric;
import org.hiero.consensus.metrics.platform.PlatformSpeedometerMetric;
import org.hiero.consensus.metrics.platform.PlatformStatEntry;

public class PlatformMetricsFactoryImpl
extends DefaultMetricsFactory
implements PlatformMetricsFactory {
    private final MetricsConfig metricsConfig;

    public PlatformMetricsFactoryImpl(@NonNull MetricsConfig metricsConfig) {
        this.metricsConfig = Objects.requireNonNull(metricsConfig, "metricsConfig is null");
    }

    @Override
    public DurationGauge createDurationGauge(DurationGauge.Config config) {
        return new PlatformDurationGauge(config);
    }

    @Override
    public <T> FunctionGauge<T> createFunctionGauge(FunctionGauge.Config<T> config) {
        return new PlatformFunctionGauge<T>(config);
    }

    @Override
    public <T> IntegerPairAccumulator<T> createIntegerPairAccumulator(IntegerPairAccumulator.Config<T> config) {
        return new PlatformIntegerPairAccumulator<T>(config);
    }

    @Override
    public RunningAverageMetric createRunningAverageMetric(RunningAverageMetric.Config config) {
        if (config.isUseDefaultHalfLife()) {
            return new PlatformRunningAverageMetric(config.withHalfLife(this.metricsConfig.halfLife()));
        }
        return new PlatformRunningAverageMetric(config);
    }

    @Override
    public SpeedometerMetric createSpeedometerMetric(SpeedometerMetric.Config config) {
        if (config.isUseDefaultHalfLife()) {
            return new PlatformSpeedometerMetric(config.withHalfLife(this.metricsConfig.halfLife()));
        }
        return new PlatformSpeedometerMetric(config);
    }

    @Override
    public StatEntry createStatEntry(StatEntry.Config<?> config) {
        return new PlatformStatEntry(config);
    }
}

