/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableBooleanList
extends AbstractMutableList<Boolean>
implements MutableList<Boolean>,
RandomAccess {
    private final MutableBooleanList delegate;

    public BoxedMutableBooleanList(MutableBooleanList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Boolean item) {
        return this.delegate.add(item.booleanValue());
    }

    public boolean addAll(int index, Collection<? extends Boolean> c) {
        boolean[] target = new boolean[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each;
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Boolean get(int index) {
        return this.delegate.get(index);
    }

    public Boolean set(int index, Boolean element) {
        return this.delegate.set(index, element.booleanValue());
    }

    public void add(int index, Boolean element) {
        this.delegate.addAtIndex(index, element.booleanValue());
    }

    public Boolean remove(int index) {
        return this.delegate.removeAtIndex(index);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Boolean ? this.delegate.indexOf(((Boolean)o).booleanValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Boolean ? this.delegate.lastIndexOf(((Boolean)o).booleanValue()) : -1;
    }

    @Override
    public MutableList<Boolean> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

