/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.api;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.service.token.impl.ReadableAccountStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableTokenRelationStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableTokenStoreImpl;
import com.hedera.node.app.service.token.impl.api.TokenServiceApiImpl;
import com.hedera.node.app.service.token.impl.handlers.transfer.CustomFeeAssessmentStep;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.fees.NodeFeeAccumulator;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;

public enum TokenServiceApiProvider implements ServiceApiProvider<TokenServiceApi>
{
    TOKEN_SERVICE_API_PROVIDER;


    public String serviceName() {
        return "TokenService";
    }

    public TokenServiceApi newInstance(@NonNull Configuration configuration, @NonNull WritableStates writableStates, @NonNull WritableEntityCounters entityCounters, @NonNull NodeFeeAccumulator nodeFeeAccumulator) {
        return new TokenServiceApiImpl(configuration, writableStates, op -> {
            CustomFeeAssessmentStep assessor = new CustomFeeAssessmentStep((CryptoTransferTransactionBody)op);
            try {
                CustomFeeAssessmentStep.CustomFeeAssessmentResult result = assessor.assessFees(new ReadableTokenStoreImpl((ReadableStates)writableStates, (ReadableEntityCounters)entityCounters), new ReadableTokenRelationStoreImpl((ReadableStates)writableStates, (ReadableEntityCounters)entityCounters), configuration, new ReadableAccountStoreImpl((ReadableStates)writableStates, (ReadableEntityCounters)entityCounters), AccountID::hasAlias);
                return !result.assessedCustomFees().isEmpty();
            }
            catch (Exception ignore) {
                return false;
            }
        }, entityCounters, nodeFeeAccumulator);
    }
}

